# CVE-2019-14339

Content Provider URI Injection on Canon PRINT 2.5.5 (CVE-2019-14339). Proof of concept by [@0x48piraj](https://twitter.com/0x48piraj)

The **ContentProvider** in the **Canon PRINT 2.5.5** application for Android does not properly restrict data access. This allows an attacker's malicious application to obtain sensitive information including factory passwords for administrator web-interface and WPA2-PSK key.


## Impact

This bug can leak data from every printer which Canon PRINT 2.5.5 supports, i.e.

- PIXMA TS Series
- TR Series, MG Series, PRO Series, MP Series, iP Series, iX Series
- MAXIFY MB Series, iB Series
- ImagePROGRAF PRO Series, TM Series
- SELPHY CP900 Series, CP1200, CP1300

#### App downloads : 1,00,00,000 +


## Coverage

- [MITRE](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-14339)
- [National Vulnerability Database](https://nvd.nist.gov/vuln/detail/CVE-2019-14339)
- [exploit-db](https://www.exploit-db.com/exploits/47321)
- [Packet Storm Security](https://packetstormsecurity.com/files/cve/CVE-2019-14339)
- [offensive-security/exploitdb](https://github.com/offensive-security/exploitdb/blob/master/exploits/android/local/47321.txt)
- [CX Security](https://cxsecurity.com/issue/WLB-2019090010)
- [Vulners](https://vulners.com/packetstorm/PACKETSTORM:154266)
- [exploit-database.net](https://www.exploit-database.net/?id=101915)
- [Hackernews Blog](https://hackernews.blog/canon-print-2-5-5-information-disclosure/)
- [security-db](http://www.security-db.com/vulnerabilites.html)
- [media.cert.europa.eu](https://media.cert.europa.eu/cert/filteredition/en/VulnerabilitiesCrypto.htm)
- [cnnvd.org.cn](http://www.cnnvd.org.cn/web/xxk/ldxqById.tag?CNNVD=CNNVD-201908-2263)


## The bug

The mobile application contains unprotected exported content providers ('IJPrinterCapabilityProvider'in `android/AndroidManifest.xml`) that discloses sensitive application’s data under certain conditions.

To securely export the content provider, one should restrict access to it by setting up `android:protectionLevel` or `android:grantUriPermissions` attributes in **Android Manifest** file.

## What do you need?

- Canon PRINT 2.5.5 (latest) Android app installed.
- A Canon printer supported by the application

## How do I run it?

There are two ways to test this vulnerability.

- Over ADB
- Via malicious Android app

### Over ADB

Setup ADB, clone the repository, goto `/poc-scripts` and run `leak.py`

```
git clone https://github.com/0x48piraj/CVE-2019-14339
cd CVE-2019-14339/poc-scripts
python leak.py
```

### Via malicious Android app

#### Method #1

Clone the repository, build the source.

#### Method #2

Use pre-built app by going under `/release` and downloading [cannon-pwn.apk](/release/cannon-pwn.apk) or via [releases](https://github.com/0x48piraj/CVE-2019-14339/releases)

> **NOTE:** Disable Play Protect or it'll throw "App Not Installed" error, (within Google Play)> Menu> Play Protect> Scan device for security threats (disable).

## Demo

#### Leak Script Demo

![leak-script](/demo/demo-script.gif)

#### Malicious Android app

![malicious-app](/demo/demo-malicious-app.gif)

## Issues (?)

Issues have been disabled on this repository. It is a simple proof of concept I wanted to share with the community.

## References

- Standards Mapping - Common Weakness Enumeration CWE ID 89
- Standards Mapping - DISA Control Correlation Identifier Version 2 CCI-002754
- Standards Mapping - FIPS200 SI
- Standards Mapping - General Data Protection Regulation (GDPR) Indirect Access to Sensitive Data
- Standards Mapping - NIST Special Publication 800-53 Revision 4 SI-10 Information Input Validation (P1)
- Standards Mapping - OWASP Mobile 2014 M7 Client Side Injection
- Standards Mapping - OWASP Top 10 2017 A1 Injection Flaws
- Standards Mapping - SANS Top 25 2011 Insecure Interaction - CWE ID 089
- Standards Mapping - Web Application Security Consortium Version 2.00 SQL Injection (WASC-19)
