# Anviz M3 RFID Access Control security issues

Security issues have been found in the Anviz M3 RFID Access Control device when working in standalone mode connected to a TCP/IP network, that could lead to access control bypass and private informations leakage and alteration.



### Advisory information

TITLE: Anviz M3 RFID Access Control security issues

ADVISORY URL: https://github.com/wizlab-it/anviz-m3-rfid-cve-2019-11523-poc/

DATE PUBLISHED: 2019/05/22

AFFECTED VENDORS: Anviz

AFFECTED PRODUCT: M3 Outdoor RFID Access Control (https://www.anviz.com/product/69.html)

CVE: CVE-2019-11523



### Product description

From the vendor website:

> M3 is a metal casing, IP65 water-proof design compact access control device, suitable for outdoor applications.It is compatible with ISO14443 contactless card standards, support 13.56MHZ mifare card and 125KHZ EM card. The touch backlit keypad, support TCP/IP and RS485 communication convenient for customers to use. The M3 both with built-in relay for direct lock and standard wiegand output, can be work as standalone access control and RFID reader all in one device.

The M3 devices stores internally informations about users' RFID badges and/or passcodes, and grants access if a valid RFID badge is presented or valid passcode is entered.

The M3 device can be managed using the CrossChex software. It can be connected to the PC via USB cable or Ethernet cable in a privare/public TCP/IP network for remote management and monitoring.



### Details of vulnerabilities

Security issues have been found when the M3 device is connected on a TCP/IP network.

The communication protocol has no authentication or encryption. Opening a connection on the device allows the attacker to send any command and retrieve/alter any information from/on the internal memory.

List of main actions:

- send the "open door" command
- retrieve list of users (includes RFID and passcode in plaintext)
- retrieve and alter users in local memory (show, add, edit, delete)
- retrieve and alter access records

Same kind of actions can be executed either from a local (private) and remote (public, internet) network.

A Python PoC script has been released to describe the vulnerabilities that have been found. The script allows also to scan the local network looking for Anviz devices (MAC address matching).



### Disclosure timeline

- 2019/04/10 - Vulnerabilities found
- 2019/04/10 - Report to Anviz (e-mail sent to the support address)
- 2019/04/18 - Anviz acknowledge the reception of the report
- 2019/04/19 - Anviz required more info about the version of the M3 device in use and provided some possible workarounds to the problem
- 2019/04/19 - Report to Anviz saying the workarounds are ineffective
- 2019/04/23 - Anviz confirmed the M3 Pro will replace the M3 device
- 2019/04/25 - Received a CVE from Mitre (CVE-2019-11523)
- 2019/04/29 - Anviz confirmed they have fixed the bugs in M3pro devices
- 2019/05/08 - Anviz released M3 Pro device
- 2019/05/20 - Agreement on the date of CVE-2019-11523 public disclosure
- 2019/05/22 - Public disclosure



### Solution

Anviz said the bugs have been fixed in the M3 Pro device (https://www.anviz.com/product/119.html).

M3 Pro has not been tested here.



### Mitigation

A mitigation is to keep the M3 device disconnected from a TCP/IP network, losing all the remote monitoring and management functionalities over TCP/IP.



### Alternative protocols

M3 device also supports Wiegand Protocol and RS485: these have not been tested here.



### Credits

WizLab.it



### References

Product page: https://www.anviz.com/product/69.html

PoC: https://github.com/wizlab-it/anviz-m3-rfid-cve-2019-11523-poc/

WizLab.it: https://www.wizlab.it
