# Zip Slip Demo

This project demonstrates the **Zip Slip vulnerability (CVE-2019-10743)** using the vulnerable version of the `mholt/archiver` package.

## What is Zip Slip?

Zip Slip is vulnerability that was uncovered by the security researchers from Snyk.
It was found that the vulnerability is impacting muliple packages that are being used in the wild. The vulnerability can be exploited so that it could lead to issues such as:

- Remote code execution
- Arbitrary write on the system can be used in order to crash the system
- Defacing websites and damaging reputation
- Being able to rewrite various pages in the website could result in order vulnerabilities such as XSS

## Vulnerability Details

- **CVE**: CVE-2019-10743
- **Package**: github.com/mholt/archiver
- **Vulnerable Versions**: >= 3.0.0, < 3.3.2
- **Patched Version**: 3.3.2
- **CVSS Score**: 5.5 (Moderate)

## mholt/archiver

[`mholt/archiver`](https://github.com/mholt/archiver) is a Go package that provides a simple and consistent API for working with archive files and compressed files. It supports formats such as `.zip`, `.tar`, `.tar.gz`, `.7z` or `.rar`.

### Key Features

- Easy-to-use interfaces for:
  - Archiving: creating archive files from directories or file lists
  - Unarchiving: extracting files from archives
  - Compression and decompression of single files
- Automatic format detection based on file extension
- Uniform APIs regardless of archive or compression type

## How the Vulnerability Works

1. The server accepts ZIP files via HTTP POST
2. It extracts files using the vulnerable `mholt/archiver` package
3. Malicious ZIP files can contain path traversal filenames (e.g., `../../../../../tmp/hacked.txt`)
4. These paths can escape the intended extraction directory
5. This can lead to arbitrary file overwrites and potential code execution

## Running the Demo

### Using Docker (Recommended)

```bash
# Start the vulnerable server
./docker-run.sh start

# Stop the server
./docker-run.sh stop

# View logs
./docker-run.sh logs

# Clean up
./docker-run.sh cleanup
```

**Observation:** Ensure that docker-run.sh has execution rights:

```bash
# Give execution rights
chmod +x ./docker-run.sh
```

After the container is up and running you can use a command similar to this one
in order to access the test environment:

```bash
# Connect to the container that is running the application
docker exec -it zipslip-vulnerable-server /bin/bash
```

### Testing the Vulnerability
```bash
# Install Python dependencies
pip3 install -r requirements.txt

# Execute the payload
python3 test_exploit.py -p "../../../../../../tmp/hacked.txt" -c "You were pwned!"
```

**Note:** The commands should be executable inside the container.

### Available Test Options

- `-u, --url`: Server URL (default: http://localhost:8080)
- `-z, --zip`: ZIP filename (default: malicious_test.zip)
- `-p, --path`: Path traversal filename (default: ../../../malicious_escaped.txt)
- `-c, --content`: File content

## Mitigation

To fix this vulnerability:

1. **Update the package**: Use `mholt/archiver` version 3.3.2 or later
2. **Validate paths**: Implement path validation before extraction
3. **Use safe extraction**: Use libraries that validate and sanitize file path
4. **Limit app permissions**: Implement the least priviledge principle and limit the permissions of the user that is running the application

## References

- [CVE-2019-10743](https://nvd.nist.gov/vuln/detail/CVE-2019-10743)
- [GitHub Advisory](https://github.com/advisories/GHSA-h74j-692g-48mq)
- [Zip Slip Vulnerability Research](https://snyk.io/research/zip-slip-vulnerability)
