﻿#define GNU_SOURCE

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/syscall.h>
#include <unistd.h>
#include <sys/stat.h>

#define N_HCI 15
#define HCI_UART_MRVL 11
#define HCI_UART_INTEL 6
#define HCI_UART_ATH3K	5

#define HCIUARTSETPROTO		_IOW('U', 200, int)

static int syz_open_pts(int a0)
{
  int ptyno = 0;
  char buf[20]={0};
  int ret;

  if (ioctl(a0, TIOCGPTN, &ptyno)){
	perror("ioctl TIOCGPTN");
	return -1;
  }

  sprintf(buf, "/dev/pts/%d", ptyno);

  if(chmod(buf,S_IRUSR|S_IWUSR|S_IWGRP)<0){
		perror("chmod");
		return -1;
  }

  if(ioctl(a0,TIOCSPTLCK,&ret)<0){
		perror("ioctl TIOCSPTLCK");
		return -1;
  }
  
  return open(buf, O_RDWR);
}

int main(int argc, char** argv)
{
	int ldisc = N_HCI;
	int proto = HCI_UART_MRVL;
	int fd,fd1,ret;
	fd = open("/dev/ptmx",O_RDWR | O_NOCTTY);
	if (fd == -1){
		perror("open");
		return 0;
	}
	fd1 =  syz_open_pts(fd);
	if(fd1 == -1){
		perror("syz_open_pts");
		goto _close;
	}
	
	/* configure line settings */
	ret = ioctl ( fd1 , TIOCSETD , &ldisc ) ;
	if(ret == -1){
		perror("ioctl TIOCSETD");
		goto _close;
	}
	ret = ioctl ( fd1 , HCIUARTSETPROTO , HCI_UART_MRVL ) ;
	if(ret == -1){
		perror("ioctl HCIUARTSETPROTO");
		goto _close;
	}
	
_close:
	close(fd);
	return 0;
}



