# TriBell_Edge_SandBox_Escape
Tribell Edge Sandbox Escape - PoCs of Edge's legacy vulnerabilities BadgeUpdateManager / TileFlyoutUpdateManager / ToastNotificationManager to exploit cross-boundary XmlDocument sharing and escape Edge’s LPAC sandbox (CVE-2019-0555). 

The PoCs trigger the execution of notepad.exe within the Just-In-Time (JIT) compilation process.

## Tested Environment
- Windows 10 Version 1809 (OS Build 17763.107)
- Microsoft Edge
  - Microsoft Edge 44.17763.1.0
  - Microsoft EdgeHTML 18.17763

## Vulnerabilities
- Edge Type Confusion: [CVE-2019-0567](https://project-zero.issues.chromium.org/issues/42450772)
- XmlDocument Insecure Sharing Elevation of Privilege: [CVE-2019-0555](https://project-zero.issues.chromium.org/issues/42450766)

## Technical Overview
A number of **Partial Trust Windows Runtime classes** expose the `XmlDocument` class across process boundaries to less privileged callers, which in its original form could be abused to **elevate privileges and escape the Edge Content LPAC sandbox**.  

This PoC uses **BadgeUpdateManager**, **TileFlyoutUpdateManager**, and **ToastNotificationManager** to reproduce the `XmlDocument` cross-boundary exposure and achieve sandbox escape. The vulnerability has been patched by Microsoft and no longer works on fully updated systems.

While developing the exploit code, wrote and compiled the following C++ code to investigate how each class is used, and then examined GUID values and offsets in IDA.

```cpp
...
        ComPtr<ITileFlyoutUpdateManagerStatics> manager;
        HStringReference name(RuntimeClass_Windows_UI_Notifications_TileFlyoutUpdateManager);
        Check(RoGetActivationFactory(name.Get(), IID_PPV_ARGS(&manager)));
        ComPtr<IXmlDocument> doc;
        Check(manager->GetTemplateContent(TileFlyoutTemplateType::TileFlyoutTemplateType_TileFlyoutTemplate01, doc.GetAddressOf()));
        ComPtr<IXMLDOMDocument2> dom;
        Check(doc.As(&dom));
...
```

## References
- [Exploit Development: Browser Exploitation on Windows - CVE-2019-0567, A Microsoft Edge Type Confusion Vulnerability](https://connormcgarr.github.io/type-confusion-part-1/)
- [Chakra Type Confusions - PoCs of Edge's legacy JS engine vulnerabilities that inject code into the JIT process](https://github.com/ommadawn46/chakra-type-confusions?tab=readme-ov-file)
- [TileFlyoutUpdateManager Class](https://learn.microsoft.com/ja-jp/uwp/api/windows.ui.notifications.tileflyoutupdatemanager?view=winrt-26100)
- [BadgeUpdateManager Class](https://learn.microsoft.com/ja-jp/uwp/api/windows.ui.notifications.badgeupdatemanager?view=winrt-26100)
- [ToastNotificationManager Class](https://learn.microsoft.com/ja-jp/uwp/api/windows.ui.notifications.toastnotificationmanager?view=winrt-26100)
