# CVE-2018-19323: GIGABYTE GDrv Exploitation Framework

---

## Overview

This repository contains a complete and advanced exploitation framework for **CVE-2018-19323**, a critical vulnerability in the GIGABYTE `gdrv.sys` driver. This vulnerability allows unprivileged users to read and write arbitrary Model-Specific Registers (MSRs), leading to a full Ring-0 (kernel) compromise and privilege escalation to `NT AUTHORITY\SYSTEM`.

The framework is designed to be modular, robust, and feature-rich, providing a comprehensive tool for security research, red teaming, and vulnerability analysis.

### Key Features

- **Full Kernel Exploit:** Achieves privilege escalation by leaking the kernel base address via `IA32_LSTAR` MSR and executing a token-stealing shellcode.
- **Multi-Architecture Support:** Dynamically adapts to **x86**, **x64**, and **ARM64** architectures, including architecture-specific shellcodes, structures, and gadgets.
- **Advanced Evasion Engine:** Implements a wide range of anti-analysis, anti-VM, and anti-debugging techniques to bypass modern security solutions.
- **Custom Payload System:** Features a powerful payload builder for generating custom shellcodes (token steal, reverse/bind shells, etc.) with various encoding options (XOR, Shikata Ga Nai, Polymorphic).
- **Framework Integration:** Seamlessly generates modules and scripts for popular C2 frameworks, including **Metasploit**, **Cobalt Strike**, **Empire**, and **Sliver**.
- **Comprehensive Monitoring:** Includes a detailed logging and performance monitoring system that generates JSON reports with reliability scores.
- **Modular Design:** The code is organized into logical modules (`core`, `payloads`, `evasion`, `monitor`, `multiarch`, `framework`) for easy extension and maintenance.

## File Structure

```
.
├── exploit.py         # Main exploitation framework and CLI
├── core.py            # Core driver interaction and exploit primitives
├── payloads.py        # Shellcode generation, custom payloads, and encoding
├── evasion.py         # Anti-VM, anti-debugging, and persistence techniques
├── monitor.py         # Logging, performance monitoring, and reporting
├── multiarch.py       # Multi-architecture support (x86/x64/ARM64)
├── framework.py       # Integration with Metasploit, Cobalt Strike, etc.
├── tests.py           # Comprehensive unit, integration, and performance tests
└── README.md          # This documentation file
```

## Getting Started

### Requirements

- **Operating System:** Windows (tested on Windows 7, 10, 11)
- **Vulnerable Driver:** The `gdrv.sys` driver must be present on the target system.
- **Python:** Python 3.x
- **Dependencies:** `psutil`, `cryptography`, `requests`

```bash
# Install required Python packages
pip install psutil cryptography requests
```

### Usage

The main exploit framework is executed via `exploit.py`. It provides several command-line options for different operational modes.

```bash
# Display help and all available options
python exploit.py --help

# Default stealth mode (recommended)
# Runs all pre-flight evasion checks before exploitation.
python exploit.py

# Aggressive mode
# Skips evasion checks for faster execution in controlled environments.
python exploit.py --aggressive

# Debug mode
# Provides verbose logging for development and analysis.
python exploit.py --debug

# Run the full test suite
# Validates all framework components without executing the exploit.
python exploit.py --test-only
```

### Legal Warning

> [!WARNING]
> This software is intended for educational and authorized security research purposes only. Unauthorized use on any system is illegal and strictly prohibited. The author, **kali**, is not responsible for any damage or misuse of this framework.

## Technical Deep Dive

## Vulnerability Information
- **CVE ID**: CVE-2018-19323
- **CVSS Score**: 9.8 (Critical)
- **Affected Component**: GIGABYTE gdrv.sys driver
- **Impact**: Local Privilege Escalation to SYSTEM
- **Attack Vector**: Local access required
- **Real-world Usage**: Exploited by RobbinHood and APT Groups ransomware

### Vulnerability Analysis (CVE-2018-19323)

The `gdrv.sys` driver exposes an IOCTL `0xC3502580` that can be called by any user-mode application. This IOCTL takes a structure containing an operation type (read/write), an MSR register index, and a value. The driver does not perform any access control checks, allowing any process to read or write to any MSR.

This is a critical flaw because MSRs control fundamental CPU operations. Specifically, the `IA32_LSTAR` MSR (at address `0xC0000082`) stores the address of the system call handler in the kernel. By reading this MSR, we can defeat Kernel Address Space Layout Randomization (KASLR) and calculate the kernel's base address. By writing to it, we can redirect system calls to our own shellcode, achieving arbitrary code execution in Ring-0.

### Exploitation Chain

1.  **Connect to Driver:** The framework opens a handle to the `\\.\GIO` device.
2.  **Leak Kernel Base:** It reads the `IA32_LSTAR` MSR to get a pointer within the kernel, bypassing KASLR.
3.  **Payload Injection:** A token-stealing shellcode is prepared. This shellcode is designed to find the `EPROCESS` structure of the current process, locate the `EPROCESS` of the `SYSTEM` process (PID 4), and copy its security token to our process.
4.  **Hijack Execution Flow:** The address of the `IA32_LSTAR` MSR is overwritten with the address of our shellcode.
5.  **Trigger Payload:** A system call is triggered, causing the CPU to jump to our shellcode instead of the legitimate kernel handler.
6.  **Privilege Escalation:** The shellcode executes, and our process now has `NT AUTHORITY\SYSTEM` privileges.
7.  **Cleanup:** The original `IA32_LSTAR` value is restored to prevent system instability.

### Additional Features Implemented

-   **New Evasion Vectors:** The `evasion.py` module includes checks for CPU core count, disk size, recent file activity, installed programs, and advanced timing/hooking detection to create a more robust environmental fingerprint.
-   **Custom Payload System:** The `payloads.py` module allows for the dynamic generation of various payloads (reverse shells, Meterpreter, Cobalt Strike beacons) for different architectures, with multiple layers of encoding.
-   **Multi-Architecture Support:** The `multiarch.py` module provides a comprehensive abstraction layer for handling differences between x86, x64, and ARM64, including pointer sizes, calling conventions, kernel structures, and instruction sets.
-   **Framework Integration:** The `framework.py` module can generate ready-to-use modules for Metasploit (`.rb`), Cobalt Strike (`.cna`), Empire (`.py`), and Sliver (`.go`), automating the integration process for red team operations.

## Testing

The framework includes a comprehensive test suite in `tests.py`. You can run all tests to ensure the integrity and functionality of all components.

```bash
# Run all unit, integration, and performance tests
python tests.py --all

# Run only unit tests
python tests.py --unit
```

---

*This project is a demonstration of advanced exploitation techniques and should be used responsibly.*
