import javax.management.*;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.util.HashMap;
import java.util.Map;

public class JMXFullDumper {

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java JMXFullDumper <target_url>");
            System.out.println("Example: java JMXFullDumper service:jmx:rmi:///jndi/rmi://localhost:9999/jmxrmi");
            return;
        }

        String url = args[0];
        String username = "admin"; // Default username, change if necessary
        String password = "admin"; // Default password, change if necessary

        JMXConnector connector = null;
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(url);
            Map<String, Object> env = new HashMap<>();
            String[] credentials = {username, password};
            env.put(JMXConnector.CREDENTIALS, credentials);

            System.out.println("[*] Connecting to JMX server at " + url);
            connector = JMXConnectorFactory.connect(serviceURL, env);
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            System.out.println("[+] Successfully connected to JMX server.");

            // Define the MBean and the operation to be invoked
            ObjectName diagnosticCommandMBean = new ObjectName("com.sun.management:type=DiagnosticCommand");
            String operationName = "vmSystemProperties";

            // For vmSystemProperties, the parameters are null
            Object[] params = new Object[]{null};
            String[] signature = new String[]{String[].class.getName()};

            System.out.println("\n[*] Invoking '" + operationName + "' on MBean: " + diagnosticCommandMBean);

            try {
                Object result = mbsc.invoke(diagnosticCommandMBean, operationName, params, signature);
                System.out.println("\n--- JVM System Properties ---");
                System.out.println(result);
                System.out.println("\n--- End of Properties ---");

            } catch (InstanceNotFoundException e) {
                System.err.println("[-] MBean not found: " + diagnosticCommandMBean);
                System.err.println("[-] The target JVM may not have the DiagnosticCommand MBean enabled.");
            } catch (MBeanException | ReflectionException e) {
                System.err.println("[-] Failed to invoke operation '" + operationName + "': " + e.getMessage());
            }

        } catch (Exception e) {
            System.err.println("[-] An error occurred: " + e.getMessage());
        } finally {
            if (connector != null) {
                try {
                    connector.close();
                    System.out.println("\n[*] JMX connection closed.");
                } catch (Exception e) {
                    System.err.println("[-] Error closing JMX connection: " + e.getMessage());
                }
            }
        }
    }
}
