/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.exception;

import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pRequest;
import org.json.simple.JSONObject;

public class J4pRemoteException
extends J4pException {
    private int status;
    private String remoteStacktrace;
    private J4pRequest request;
    private String errorType;
    private JSONObject errorValue;
    private JSONObject response;

    public J4pRemoteException(J4pRequest pJ4pRequest, String pMessage, String pErrorType, int pStatus, String pStacktrace, JSONObject pErrorValue) {
        super(pMessage);
        this.status = pStatus;
        this.errorType = pErrorType;
        this.remoteStacktrace = pStacktrace;
        this.request = pJ4pRequest;
        this.errorValue = pErrorValue;
    }

    public J4pRemoteException(J4pRequest pJ4pRequest, JSONObject pJsonRespObject) {
        super(J4pRemoteException.generateErrorMessage(pJ4pRequest, pJsonRespObject));
        Object statusO = pJsonRespObject.get("status");
        Long statusL = statusO instanceof Long ? (Long)statusO : null;
        this.status = statusL != null ? statusL.intValue() : 500;
        this.request = pJ4pRequest;
        this.response = pJsonRespObject;
        this.errorType = (String)pJsonRespObject.get("error_type");
        this.remoteStacktrace = (String)pJsonRespObject.get("stacktrace");
        this.errorValue = (JSONObject)pJsonRespObject.get("error_value");
    }

    private static String generateErrorMessage(J4pRequest pJ4pRequest, JSONObject pJsonRespObject) {
        if (pJsonRespObject.get("error") != null) {
            return "Error: " + (String)pJsonRespObject.get("error");
        }
        Object o = pJsonRespObject.get("status");
        if (o != null && !(o instanceof Long)) {
            return "Invalid status of type " + o.getClass().getName() + "('" + o.toString() + "') received";
        }
        return "Invalid response received";
    }

    public String getErrorType() {
        return this.errorType;
    }

    public int getStatus() {
        return this.status;
    }

    public String getRemoteStackTrace() {
        return this.remoteStacktrace;
    }

    public J4pRequest getRequest() {
        return this.request;
    }

    public JSONObject getErrorValue() {
        return this.errorValue;
    }

    public JSONObject getResponse() {
        return this.response;
    }
}

