/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.utils;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.PluginSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.Remote;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import sun.misc.Unsafe;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.tcp.TCPEndpoint;

public class Utils {
    private static Pattern splitSpaces = Pattern.compile(" (?=(?:(?:[^'\"]*\"[^\"]*\")|(?:[^\"']*'[^']*'))*[^\"']*$)");
    private static Pattern envVariable = Pattern.compile("[a-zA-Z0-9_-]+\\=.+");

    public static void exit() {
        Logger.eprintln("Cannot continue from here.");
        System.exit(1);
    }

    public static void exit(Exception e) {
        ExceptionHandler.showStackTrace(e);
        Logger.eprintln("Cannot continue from here.");
        System.exit(1);
    }

    public static void exit(boolean exit) {
        if (!exit) {
            return;
        }
        Logger.eprintln("Cannot continue from here.");
        System.exit(1);
    }

    public static ObjID parseObjID(String objIdString) {
        Pattern pattern;
        Matcher matcher;
        ObjID returnValue = null;
        if (!objIdString.contains(":")) {
            try {
                long objNum = Long.parseLong(objIdString);
                return new ObjID((int)objNum);
            }
            catch (NumberFormatException e) {
                ExceptionHandler.invalidObjectId(objIdString);
            }
        }
        if (!(matcher = (pattern = Pattern.compile("\\[([0-9a-f-]+):([0-9a-f-]+):([0-9a-f-]+), ([0-9-]+)\\]")).matcher(objIdString)).find()) {
            ExceptionHandler.invalidObjectId(objIdString);
        }
        try {
            Constructor conUID = UID.class.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Short.TYPE);
            Constructor conObjID = ObjID.class.getDeclaredConstructor(Long.TYPE, UID.class);
            int unique = Integer.parseInt(matcher.group(1), 16);
            long time = Long.parseLong(matcher.group(2), 16);
            short count = (short)Integer.parseInt(matcher.group(3), 16);
            long objNum = Long.parseLong(matcher.group(4));
            conUID.setAccessible(true);
            UID uid = (UID)conUID.newInstance(unique, time, count);
            conObjID.setAccessible(true);
            returnValue = (ObjID)conObjID.newInstance(objNum, uid);
        }
        catch (Exception e) {
            ExceptionHandler.invalidObjectId(objIdString);
        }
        return returnValue;
    }

    public static String getClassName(Remote remoteObject) {
        if (Proxy.isProxyClass(remoteObject.getClass())) {
            Class<?>[] interfaces;
            for (Class<?> intf : interfaces = remoteObject.getClass().getInterfaces()) {
                String intfName = intf.getName();
                if (intfName.equals("java.rmi.Remote")) continue;
                return intfName;
            }
        }
        return remoteObject.getClass().getName();
    }

    public static Map<String, Remote> filterJmxEndpoints(Map<String, Remote> mappings) {
        HashMap<String, Remote> filteredMap = new HashMap<String, Remote>();
        for (Map.Entry<String, Remote> entry : mappings.entrySet()) {
            String className = Utils.getClassName(entry.getValue());
            if (!className.startsWith("javax.management.remote.rmi.RMIServer")) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    public static ObjectName getObjectName(String name) {
        ObjectName objName = null;
        if (name.equals("random") || name.isEmpty()) {
            String[] randomStuff = UUID.randomUUID().toString().split("-");
            name = String.format("%s:%s=%s", randomStuff[0], randomStuff[1], randomStuff[2]);
        }
        try {
            objName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            Logger.eprintlnMixedYellow("The specified ObjectName", name, "is invalid.");
            Logger.eprintlnMixedBlue("Valid ObjectNames look like this:", "de.qtc.beanshooter:version=1");
            Utils.exit();
        }
        return objName;
    }

    public static URL parseUrl(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Logger.eprintlnMixedYellow("The specified URL", urlString, "is invalid.");
            Utils.exit();
        }
        return url;
    }

    public static boolean isLocal(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            if (addr.isLoopbackAddress()) {
                return true;
            }
            if (addr.isAnyLocalAddress()) {
                return host.equals("0.0.0.0");
            }
            NetworkInterface intf = NetworkInterface.getByInetAddress(addr);
            if (intf != null) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            Logger.eprintlnMixedYellow("The specified hostname", host, "could not be resolved.");
            Utils.exit();
        }
        catch (SocketException e) {
            return false;
        }
        return false;
    }

    public static String md5sum(byte[] content) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            ExceptionHandler.internalError("Utils.md5sum", "Unsupported Hash Algorithm");
            Utils.exit();
        }
        return Utils.bytesToHex(md.digest(content));
    }

    public static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static String[] splitSpaces(String input, int requiredCount) {
        String[] splitResult = splitSpaces.split(input);
        if (splitResult.length < requiredCount) {
            Logger.eprintlnYellow("Error: Insufficient number of arguments or unbalanced number of quotes.");
            return null;
        }
        for (int ctr = 0; ctr < splitResult.length; ++ctr) {
            splitResult[ctr] = Utils.stripQuotes(splitResult[ctr]);
        }
        return splitResult;
    }

    public static byte[] readFile(String path) throws IOException {
        return Utils.readFile(new File(path));
    }

    public static byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static Map<String, String> parseEnvironmentString(String envString) {
        String[] parts;
        HashMap<String, String> env = new HashMap<String, String>();
        for (String token : parts = Utils.splitSpaces(envString, 1)) {
            if (!envVariable.matcher(token).matches()) continue;
            String[] split = token.split("\\=", 2);
            env.put(split[0], Utils.stripQuotes(split[1]));
        }
        return env;
    }

    public static String[] typesToString(Class<?>[] types) {
        String[] typeNames = new String[types.length];
        for (int ctr = 0; ctr < types.length; ++ctr) {
            typeNames[ctr] = types[ctr].getName();
        }
        return typeNames;
    }

    public static String expandPath(String path) {
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    public static String stripQuotes(String input) {
        if ((input.startsWith("\"") && input.endsWith("\"") || input.startsWith("'") && input.endsWith("'")) && input.length() != 1) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static <T> List<Set<T>> splitSet(Set<T> original, int count) {
        int i;
        ArrayList<Set<T>> result = new ArrayList<Set<T>>(count);
        Iterator<T> it = original.iterator();
        int each = original.size() / count;
        for (i = 0; i < count; ++i) {
            HashSet<T> s = new HashSet<T>(original.size() / count + 1);
            result.add(s);
            for (int j = 0; j < each && it.hasNext(); ++j) {
                s.add(it.next());
            }
        }
        for (i = 0; i < count && it.hasNext(); ++i) {
            result.get(i).add(it.next());
        }
        return result;
    }

    public static void disableWarning() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe u = (Unsafe)theUnsafe.get(null);
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            u.putObjectVolatile(cls, u.staticFieldOffset(logger), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String makeVoid(String signature) {
        signature = signature.trim();
        signature = signature.replaceAll(" *\\(", "(");
        int functionStart = signature.indexOf(32);
        int argumentsStart = signature.indexOf(40);
        if (functionStart > 0 && functionStart < argumentsStart) {
            signature = signature.substring(functionStart);
        }
        return "void " + signature;
    }

    public static Path joinIfRelative(String first, String second) {
        File secondPath = new File(second);
        if (secondPath.isAbsolute()) {
            return secondPath.toPath();
        }
        return Paths.get(first, second);
    }

    public static String getMethodString(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append("(");
        if (m.getParameterCount() != 0) {
            for (Class<?> cc : m.getParameterTypes()) {
                sb.append(cc.getName());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getMethodString(MBeanOperationInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append(info.getReturnType());
        sb.append(" ");
        sb.append(info.getName());
        sb.append("(");
        if (info.getSignature().length != 0) {
            for (MBeanParameterInfo cc : info.getSignature()) {
                sb.append(cc.getType() + " " + cc.getName());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    public static void askToContinue(String message, Exception e) {
        Scanner scanner = new Scanner(System.in);
        block15: while (true) {
            String input;
            Logger.printMixedYellow(message, "(Y/n/trace)", "");
            switch (input = scanner.nextLine().toLowerCase()) {
                case "": 
                case "y": 
                case "yes": {
                    Logger.lineBreak();
                    return;
                }
                case "t": 
                case "trace": 
                case "stacktrace": {
                    ExceptionHandler.stackTrace(e);
                    continue block15;
                }
                case "n": 
                case "no": {
                    Utils.exit();
                }
            }
            Logger.printlnRed("Invalid choice.");
        }
    }

    public static String getJmxTarget(Remote remote) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field proxyField = null;
        Field remoteField = null;
        RemoteRef remoteRef = null;
        try {
            proxyField = Proxy.class.getDeclaredField("h");
            remoteField = RemoteObject.class.getDeclaredField("ref");
            proxyField.setAccessible(true);
            remoteField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            ExceptionHandler.unexpectedException(e, "reflective access in", "extractRef", true);
        }
        remoteRef = Proxy.isProxyClass(remote.getClass()) ? ((RemoteObjectInvocationHandler)proxyField.get(remote)).getRef() : (RemoteRef)remoteField.get(remote);
        if (!(remoteRef instanceof UnicastRef)) {
            return "";
        }
        UnicastRef uref = (UnicastRef)remoteRef;
        LiveRef lref = uref.getLiveRef();
        Field endpointField = LiveRef.class.getDeclaredField("ep");
        endpointField.setAccessible(true);
        TCPEndpoint endpoint = (TCPEndpoint)endpointField.get(lref);
        String host = endpoint.getHost();
        int port = endpoint.getPort();
        return String.format("%s:%d", host, port);
    }

    public static ModelMBeanOperationInfo[] createModelMBeanInfosFromClass(Class<?> cls) {
        Method[] methods = cls.getMethods();
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        HashMap<String, String> descriptorFields = new HashMap<String, String>();
        descriptorFields.put("class", cls.getName());
        descriptorFields.put("role", "operation");
        descriptorFields.put("descriptorType", "operation");
        block2: for (Method method : methods) {
            if (!BeanshooterOption.MODEL_ALL_METHODS.getBool()) {
                for (Class<?> paramType : method.getParameterTypes()) {
                    if (!Serializable.class.isAssignableFrom(paramType)) continue block2;
                }
            }
            descriptorFields.put("name", method.getName());
            descriptorFields.put("displayName", method.getName());
            ImmutableDescriptor methodDescriptor = new ImmutableDescriptor(descriptorFields);
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(method.getName(), method, (Descriptor)methodDescriptor);
            infos.add(info);
        }
        try {
            Method setManagedResource = RequiredModelMBean.class.getMethod("setManagedResource", Object.class, String.class);
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo("setManagedResource", setManagedResource);
            infos.add(info);
        }
        catch (NoSuchMethodException | SecurityException e) {
            ExceptionHandler.internalError("createModelMBeanInfosFromClass", "unable to find setManagedResource method");
        }
        return infos.toArray(new ModelMBeanOperationInfo[0]);
    }

    public static ModelMBeanOperationInfo[] createModelMBeanInfosFromArg(String className) {
        ArrayList<ModelMBeanOperationInfo> operationInfos = new ArrayList<ModelMBeanOperationInfo>();
        if (BeanshooterOption.MODEL_SIGNATURE.notNull()) {
            ModelMBeanOperationInfo operationInfo = Utils.crateModelMBeanInfoFromString(className, (String)BeanshooterOption.MODEL_SIGNATURE.getValue());
            operationInfos.add(operationInfo);
        } else if (BeanshooterOption.MODEL_SIGNATURE_FILE.notNull()) {
            try (BufferedReader br = new BufferedReader(new FileReader((String)BeanshooterOption.MODEL_SIGNATURE_FILE.getValue()));){
                String line;
                while ((line = br.readLine()) != null) {
                    ModelMBeanOperationInfo operationInfo = Utils.crateModelMBeanInfoFromString(className, line);
                    operationInfos.add(operationInfo);
                }
            }
            catch (FileNotFoundException e) {
                Logger.printlnMixedYellow("Caught unexpected", "FileNotFoundException", "while preparing method signatures.");
                Logger.printlnMixedBlue("The specified input file", (String)BeanshooterOption.MODEL_SIGNATURE_FILE.getValue(), "seems not to exist.");
                Utils.exit(e);
            }
            catch (IOException e) {
                ExceptionHandler.handleFileRead(e, (String)BeanshooterOption.MODEL_SIGNATURE_FILE.getValue(), true);
            }
        } else {
            ExceptionHandler.internalError("createModelMBeanInfosFromArg", "Method was called but neither --signature nor --signature file was specified");
        }
        try {
            Method setManagedResource = RequiredModelMBean.class.getMethod("setManagedResource", Object.class, String.class);
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo("setManagedResource", setManagedResource);
            operationInfos.add(info);
        }
        catch (NoSuchMethodException | SecurityException e) {
            ExceptionHandler.internalError("createModelMBeanInfosFromClass", "unable to find setManagedResource method");
        }
        return operationInfos.toArray(new ModelMBeanOperationInfo[0]);
    }

    public static ModelMBeanOperationInfo crateModelMBeanInfoFromString(String className, String method) {
        String[] methodDesc = PluginSystem.getArgumentTypes(method, true);
        String returnValue = method.split(" ", 2)[0];
        HashMap<String, String> descriptorFields = new HashMap<String, String>();
        descriptorFields.put("name", methodDesc[0]);
        descriptorFields.put("displayName", methodDesc[0]);
        descriptorFields.put("class", className);
        descriptorFields.put("role", "operation");
        descriptorFields.put("descriptorType", "operation");
        ImmutableDescriptor methodDescriptor = new ImmutableDescriptor(descriptorFields);
        MBeanParameterInfo[] paramInfos = new MBeanParameterInfo[methodDesc.length - 1];
        for (int ctr = 1; ctr < methodDesc.length; ++ctr) {
            paramInfos[ctr - 1] = new MBeanParameterInfo(null, methodDesc[ctr], null);
        }
        return new ModelMBeanOperationInfo(methodDesc[0], null, paramInfos, returnValue, 3, methodDescriptor);
    }
}

