/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.utils;

import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.jmxadapter.JolokiaJmxConnector;

public class ExtendedJolokiaJmxConnector
extends JolokiaJmxConnector {
    private final String target;

    public ExtendedJolokiaJmxConnector(JMXServiceURL serviceURL, Map<String, ?> environment, String target) {
        super(serviceURL, environment);
        this.target = target;
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        if (!"jolokia".equals(this.serviceUrl.getProtocol())) {
            throw new MalformedURLException(String.format("Invalid URL %s : Only protocol \"jolokia\" is supported (not %s)", this.serviceUrl, this.serviceUrl.getProtocol()));
        }
        Map<String, Object> mergedEnv = this.mergedEnvironment(env);
        String internalProtocol = "http";
        if (BeanshooterOption.CONN_SSL.getBool()) {
            internalProtocol = "https";
        }
        J4pClientBuilder clientBuilder = new J4pClientBuilder().url(internalProtocol + "://" + this.serviceUrl.getHost() + ":" + this.serviceUrl.getPort() + this.prefixWithSlashIfNone(this.serviceUrl.getURLPath()));
        try {
            NoopHostnameVerifier verifier = NoopHostnameVerifier.INSTANCE;
            SSLContext ctx = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory facs = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)verifier);
            clientBuilder.sslConnectionSocketFactory(facs);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            Logger.printlnMixedYellow("Caught unexpected", e.getClass().getName(), "while setting the SSL context for Jolokia.");
            Utils.exit(e);
        }
        if (mergedEnv.containsKey("jmx.remote.credentials")) {
            String[] credentials = (String[])mergedEnv.get("jmx.remote.credentials");
            clientBuilder.user(credentials[0]);
            clientBuilder.password(credentials[1]);
        }
        if (this.target != null) {
            clientBuilder.target(this.target);
            String proxyUser = (String)BeanshooterOption.CONN_JOLOKIA_PROXY_USER.getValue();
            String proxyPass = (String)BeanshooterOption.CONN_JOLOKIA_PROXY_PASS.getValue();
            if (proxyUser != null && proxyPass != null) {
                clientBuilder.targetUser(proxyUser);
                clientBuilder.targetPassword(proxyPass);
            }
        }
        this.adapter = this.instantiateAdapter(clientBuilder, mergedEnv);
        this.postCreateAdapter();
    }

    private String prefixWithSlashIfNone(String urlPath) {
        if (urlPath.startsWith("/")) {
            return urlPath;
        }
        return "/" + urlPath;
    }
}

