/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin.providers;

import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.MissingCredentialsException;
import de.qtc.beanshooter.exceptions.WrongCredentialsException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.IMBeanServerProvider;
import de.qtc.beanshooter.utils.ExtendedJolokiaJmxConnector;
import de.qtc.beanshooter.utils.Utils;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.rmi.ConnectIOException;
import java.security.cert.CertPathValidatorException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.exception.UncheckedJmxAdapterException;
import org.json.simple.parser.ParseException;

public class JolokiaProvider
implements IMBeanServerProvider {
    @Override
    public MBeanServerConnection getMBeanServerConnection(String host, int port, Map<String, Object> env) throws AuthenticationException, J4pRemoteException {
        MBeanServerConnection mBeanServerConnection = null;
        String endpoint = BeanshooterOption.CONN_JOLOKIA_ENDPOINT.getValue("/jolokia/");
        String connString = String.format("service:jmx:jolokia://%s:%d%s", host, port, endpoint);
        try {
            JMXServiceURL jmxUrl = new JMXServiceURL(connString);
            ExtendedJolokiaJmxConnector connector = new ExtendedJolokiaJmxConnector(jmxUrl, env, (String)BeanshooterOption.CONN_JOLOKIA_PROXY.getValue());
            connector.connect();
            mBeanServerConnection = connector.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
            ExceptionHandler.internalError("DefaultMBeanServerProvider.getMBeanServerConnection", "Invalid URL.");
        }
        catch (UncheckedJmxAdapterException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof J4pRemoteException) {
                J4pRemoteException j4p = (J4pRemoteException)t;
                if (!(j4p.getStatus() != 401 && j4p.getStatus() != 403 || j4p.getMessage().contains("not allowed by configuration"))) {
                    if (env.containsKey("jmx.remote.credentials")) {
                        throw new WrongCredentialsException(e);
                    }
                    throw new MissingCredentialsException(e);
                }
                throw j4p;
            }
            if (t instanceof ParseException) {
                Logger.eprintlnMixedYellow("Caught", "ParseException", "while parsing the server response.");
                Logger.eprintlnMixedBlue("The specified target is", "probably not", "a Jolokia endpoint.");
                Utils.exit(e);
            }
            ExceptionHandler.unexpectedException(e, "while connecting", "to the jolokia endpoint", true);
        }
        catch (IOException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ConnectException) {
                if (t.getMessage().contains("Connection refused")) {
                    Logger.eprintlnMixedBlue("The JMX remote object", "refused", "the connection.");
                } else if (t.getMessage().contains("Network is unreachable")) {
                    Logger.eprintlnMixedBlue("The JMX remote object is", "unreachable.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
            } else if (t instanceof ConnectIOException) {
                ExceptionHandler.connectIOException(e, "newclient");
            } else if (t instanceof CertPathValidatorException) {
                Logger.eprintlnMixedBlue("The server probably uses TLS settings that are", "incompatible", "with your current security settings.");
                Logger.eprintlnMixedYellow("You may try to edit your", "java.security", "policy file to overcome the issue.");
                ExceptionHandler.showStackTrace(e);
            } else if (t instanceof EOFException || t instanceof SocketException) {
                Logger.eprintln("The JMX server closed the connection. This usually indicates a networking problem.");
                ExceptionHandler.showStackTrace(e);
            } else {
                Logger.eprintlnMixedYellow("Caught unexpected", "IOException", "while connecting to the specified JMX service.");
                ExceptionHandler.showStackTrace(e);
            }
            Utils.exit();
        }
        return mBeanServerConnection;
    }
}

