/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin.providers;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.IArgumentProvider;
import de.qtc.beanshooter.utils.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class ArgumentProvider
implements IArgumentProvider {
    private Method targetMethod = null;

    @Override
    public Object[] getArgumentArray(String[] arguments) {
        if (arguments.length != this.targetMethod.getParameterCount()) {
            ExceptionHandler.argumentCountMismatch(arguments.length, this.targetMethod.getParameterCount());
        } else if (arguments.length == 0) {
            return new Object[0];
        }
        Object[] result = null;
        ClassPool pool = ClassPool.getDefault();
        String argumentString = this.wrapArguments(arguments);
        try {
            CtClass evaluator = pool.makeClass("de.qtc.rmg.plugin.providers.DefaultArgumentProvider");
            String evalFunction = "public static Object[] eval() {        return new Object[] { " + argumentString + " };}";
            CtMethod me = CtNewMethod.make(evalFunction, evaluator);
            evaluator.addMethod(me);
            Class<?> evalClass = evaluator.toClass();
            Method m = evalClass.getDeclaredMethods()[0];
            result = (Object[])m.invoke(evalClass, (Object[])null);
        }
        catch (VerifyError | CannotCompileException e) {
            ExceptionHandler.invalidArgumentException(e, argumentString);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "argument array", "generation", true);
        }
        return result;
    }

    @Override
    public Object strToObj(String str) {
        Object result = null;
        ClassPool pool = ClassPool.getDefault();
        try {
            CtClass evaluator = pool.makeClass("de.qtc.rmg.plugin.providers.DefaultArgumentProvider");
            String evalFunction = "public static Object eval() {        return " + str + ";}";
            CtMethod me = CtNewMethod.make(evalFunction, evaluator);
            evaluator.addMethod(me);
            Class<?> evalClass = evaluator.toClass();
            Method m = evalClass.getDeclaredMethods()[0];
            result = m.invoke(evalClass, (Object[])null);
        }
        catch (VerifyError | CannotCompileException e) {
            ExceptionHandler.invalidArgumentException(e, str);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "argument array", "generation", true);
        }
        return result;
    }

    @Override
    public String[] getArgumentTypes(String signature) {
        return this.getArgumentTypes(signature, false);
    }

    @Override
    public String[] getArgumentTypes(String signature, boolean includeName) {
        ClassPool pool = ClassPool.getDefault();
        ArrayList<String> result = new ArrayList<String>();
        signature = Utils.makeVoid(signature);
        try {
            CtClass evaluator = pool.makeClass("de.qtc.rmg.plugin.providers.DefaultArgumentProvider2" + System.nanoTime());
            String dummyFunction = "public static " + signature + " {}";
            CtMethod me = CtNewMethod.make(dummyFunction, evaluator);
            evaluator.addMethod(me);
            Class<?> evalClass = evaluator.toClass();
            this.targetMethod = evalClass.getDeclaredMethods()[0];
            if (includeName) {
                result.add(this.targetMethod.getName());
            }
            for (Class<?> type : this.targetMethod.getParameterTypes()) {
                result.add(type.getName());
            }
        }
        catch (VerifyError | CannotCompileException e) {
            ExceptionHandler.invalidSignature(e, signature);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "argument array", "generation", true);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getMethodName(String signature) {
        return this.targetMethod.getName();
    }

    private String wrapArguments(String[] argumentArray) {
        ArrayList<String> wrappedArgs = new ArrayList<String>();
        Class<?>[] paramTypes = this.targetMethod.getParameterTypes();
        for (int ctr = 0; ctr < argumentArray.length; ++ctr) {
            wrappedArgs.add(this.wrap(argumentArray[ctr], paramTypes[ctr]));
        }
        return String.join((CharSequence)", ", wrappedArgs);
    }

    private String wrap(String argument, Class<?> type) {
        if (!BeanshooterOption.INVOKE_NO_WRAP.getBool()) {
            if (type == Integer.TYPE) {
                return String.format("Integer.valueOf(%s)", argument);
            }
            if (type == Long.TYPE) {
                return String.format("Long.valueOf(%s)", argument);
            }
            if (type == Short.TYPE) {
                return String.format("Short.valueOf(%s)", argument);
            }
            if (type == Double.TYPE) {
                return String.format("Double.valueOf(%s)", argument);
            }
            if (type == Float.TYPE) {
                return String.format("Float.valueOf(%s)", argument);
            }
            if (type == Byte.TYPE) {
                return String.format("Byte.valueOf(%s)", argument);
            }
            if (type == Boolean.TYPE) {
                return String.format("Boolean.valueOf(%s)", argument);
            }
            if (type == Character.TYPE) {
                return String.format("Char.valueOf(%s)", argument);
            }
            if (type == String.class) {
                return String.format("\"%s\"", argument.replace("\"", "\\\""));
            }
        }
        return argument;
    }
}

