/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.MalformedPluginException;
import de.qtc.beanshooter.exceptions.PluginException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.IArgumentProvider;
import de.qtc.beanshooter.plugin.IAuthenticationProvider;
import de.qtc.beanshooter.plugin.IMBeanServerProvider;
import de.qtc.beanshooter.plugin.IPayloadProvider;
import de.qtc.beanshooter.plugin.IResponseHandler;
import de.qtc.beanshooter.plugin.ISocketFactoryProvider;
import de.qtc.beanshooter.plugin.providers.ArgumentProvider;
import de.qtc.beanshooter.plugin.providers.AuthenticationProvider;
import de.qtc.beanshooter.plugin.providers.JMXMPProvider;
import de.qtc.beanshooter.plugin.providers.JNDIProvider;
import de.qtc.beanshooter.plugin.providers.JolokiaProvider;
import de.qtc.beanshooter.plugin.providers.RMIProvider;
import de.qtc.beanshooter.plugin.providers.ResponseHandlerProvider;
import de.qtc.beanshooter.plugin.providers.SocketFactoryProvider;
import de.qtc.beanshooter.plugin.providers.YsoSerialProvider;
import de.qtc.beanshooter.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.management.MBeanServerConnection;
import javax.net.SocketFactory;
import org.jolokia.client.exception.J4pRemoteException;

public class PluginSystem {
    private static IMBeanServerProvider mBeanServerProvider;
    private static ISocketFactoryProvider socketFactoryProvider;
    private static IPayloadProvider payloadProvider;
    private static IArgumentProvider argumentProvider;
    private static IResponseHandler responseHandler;
    private static IAuthenticationProvider authenticationProvider;
    private static final String manifestAttribute = "BeanshooterPluginClass";

    public static void init(String pluginPath) {
        mBeanServerProvider = PluginSystem.selectProvider();
        socketFactoryProvider = new SocketFactoryProvider();
        payloadProvider = new YsoSerialProvider();
        argumentProvider = new ArgumentProvider();
        responseHandler = new ResponseHandlerProvider();
        authenticationProvider = new AuthenticationProvider();
        if (pluginPath != null) {
            PluginSystem.loadPlugin(pluginPath);
        }
    }

    private static void loadPlugin(String pluginPath) {
        boolean inUse = false;
        Object pluginInstance = null;
        String pluginClassName = null;
        JarInputStream jarStream = null;
        File pluginFile = new File(pluginPath);
        if (!pluginFile.exists()) {
            Logger.eprintlnMixedYellow("Specified plugin path", pluginPath, "does not exist.");
            Utils.exit();
        }
        try {
            jarStream = new JarInputStream(new FileInputStream(pluginFile));
            Manifest mf = jarStream.getManifest();
            pluginClassName = mf.getMainAttributes().getValue(manifestAttribute);
            jarStream.close();
            if (pluginClassName == null) {
                throw new MalformedPluginException();
            }
        }
        catch (Exception e) {
            Logger.eprintlnMixedYellow("Caught", e.getClass().getName(), "while reading the Manifest of the specified plugin.");
            Logger.eprintlnMixedBlue("Plugins need to be valid JAR files that contain the", manifestAttribute, "attribute.");
            Utils.exit(e);
        }
        try {
            URLClassLoader ucl = new URLClassLoader(new URL[]{pluginFile.toURI().toURL()});
            Class<?> pluginClass = Class.forName(pluginClassName, true, ucl);
            pluginInstance = pluginClass.newInstance();
        }
        catch (Exception e) {
            Logger.eprintMixedYellow("Caught", e.getClass().getName(), "while reading plugin file ");
            Logger.printlnPlainBlue(pluginPath);
            Utils.exit(e);
        }
        if (pluginInstance instanceof IMBeanServerProvider) {
            mBeanServerProvider = pluginInstance;
            inUse = true;
        }
        if (pluginInstance instanceof ISocketFactoryProvider) {
            socketFactoryProvider = pluginInstance;
            inUse = true;
        }
        if (pluginInstance instanceof IPayloadProvider) {
            payloadProvider = pluginInstance;
            inUse = true;
        }
        if (pluginInstance instanceof IArgumentProvider) {
            argumentProvider = pluginInstance;
            inUse = true;
        }
        if (pluginInstance instanceof IResponseHandler) {
            responseHandler = pluginInstance;
            inUse = true;
        }
        if (pluginInstance instanceof IAuthenticationProvider) {
            authenticationProvider = pluginInstance;
            inUse = true;
        }
        if (!inUse) {
            Logger.eprintMixedBlue("Plugin", pluginPath, "was successfully loaded, but is ");
            Logger.eprintlnPlainYellow("not in use.");
            Logger.eprintln("Plugins should implement at least one of the available plugin interfaces.");
        }
    }

    private static IMBeanServerProvider selectProvider() {
        if (BeanshooterOption.CONN_JMXMP.getBool()) {
            return new JMXMPProvider();
        }
        if (BeanshooterOption.CONN_JNDI.notNull()) {
            return new JNDIProvider();
        }
        if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
            return new JolokiaProvider();
        }
        return new RMIProvider();
    }

    public static MBeanServerConnection getMBeanServerConnection(String host, int port, Map<String, Object> env) {
        MBeanServerConnection conn = null;
        try {
            conn = mBeanServerProvider.getMBeanServerConnection(host, port, env);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "while connecting to the Jolokia endpoint.");
        }
        catch (AuthenticationException e) {
            ExceptionHandler.handleAuthenticationException(e);
            Utils.exit();
        }
        return conn;
    }

    public static MBeanServerConnection getMBeanServerConnectionUmanaged(String host, int port, Map<String, Object> env) throws AuthenticationException, J4pRemoteException {
        MBeanServerConnection connection = null;
        try {
            connection = mBeanServerProvider.getMBeanServerConnection(host, port, env);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return connection;
    }

    public static RMIClientSocketFactory getRMIClientSocketFactory(String host, int port) {
        RMIClientSocketFactory facs = null;
        try {
            facs = socketFactoryProvider.getRMIClientSocketFactory(host, port);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return facs;
    }

    public static RMISocketFactory getDefaultRMISocketFactory(String host, int port) {
        RMISocketFactory facs = null;
        try {
            facs = socketFactoryProvider.getDefaultRMISocketFactory(host, port);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return facs;
    }

    public static String getDefaultSSLSocketFactoryClass(String host, int port) {
        String cls = null;
        try {
            cls = socketFactoryProvider.getDefaultSSLSocketFactoryClass(host, port);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return cls;
    }

    public static SocketFactory getSSLSocketFactory(String host, int port) {
        SocketFactory facs = null;
        try {
            facs = socketFactoryProvider.getSSLSocketFactory(host, port);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return facs;
    }

    public static Object getPayloadObject(Operation op, String gadgetName, String gadgetCmd) {
        Object payload = null;
        try {
            payload = payloadProvider.getPayloadObject(op, gadgetName, gadgetCmd);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return payload;
    }

    public static IMBeanServerProvider getMBeanServerProvider() {
        return mBeanServerProvider;
    }

    public static Object[] getArgumentArray(String[] argumentArray) {
        Object[] args = null;
        try {
            args = argumentProvider.getArgumentArray(argumentArray);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return args;
    }

    public static Object strToObj(String str) {
        Object args = null;
        try {
            args = argumentProvider.strToObj(str);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return args;
    }

    public static String[] getArgumentTypes(String signature) {
        String[] types = null;
        try {
            types = argumentProvider.getArgumentTypes(signature);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return types;
    }

    public static String[] getArgumentTypes(String signature, boolean includeName) {
        String[] types = null;
        try {
            types = argumentProvider.getArgumentTypes(signature, includeName);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return types;
    }

    public static String getMethodName(String signature) {
        String method = null;
        try {
            method = argumentProvider.getMethodName(signature);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return method;
    }

    public static void handleResponse(Object response) {
        try {
            responseHandler.handleResponse(response);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
    }

    public static Map<String, Object> getEnv(String username, String password) {
        Map<String, Object> map = null;
        try {
            map = authenticationProvider.getEnv(username, password);
        }
        catch (PluginException e) {
            ExceptionHandler.pluginException(e);
        }
        return map;
    }
}

