/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.operation;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.DynamicMBean;
import de.qtc.beanshooter.mbean.mlet.Dispatcher;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.UnmarshalException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.exception.UncheckedJmxAdapterException;

public class MBeanServerClient {
    private final MBeanServerConnection conn;

    public MBeanServerClient(MBeanServerConnection conn) {
        this.conn = conn;
    }

    public boolean isRegistered(ObjectName name) {
        boolean result = false;
        try {
            if (this.conn.isRegistered(name)) {
                result = true;
            }
        }
        catch (IOException e) {
            ExceptionHandler.unexpectedException(e, "checking", "registration status", false);
        }
        return result;
    }

    public void deployMBean(String mBeanClassName, ObjectName mBeanObjectName, String jarFile) {
        this.deployMBean(mBeanClassName, mBeanObjectName, jarFile, null, null);
    }

    public void deployMBean(String mBeanClassName, ObjectName mBeanObjectName, String jarFile, Object[] params, String[] signature) {
        String className = mBeanClassName.substring(mBeanClassName.lastIndexOf(".") + 1);
        Logger.printlnMixedYellow("Deplyoing MBean:", className);
        try {
            if (this.conn.isRegistered(mBeanObjectName)) {
                Logger.printlnMixedBlue("MBean with object name", mBeanObjectName.toString(), "is already deployed.");
                return;
            }
            if (params == null || signature == null) {
                this.conn.createMBean(mBeanClassName, mBeanObjectName);
            } else {
                this.conn.createMBean(mBeanClassName, mBeanObjectName, params, signature);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            Logger.printlnMixedYellowFirst(className, "is already deployed.");
            return;
        }
        catch (UnsupportedOperationException e) {
            Logger.lineBreak();
            if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
                ExceptionHandler.jolokiaCreateMBean(e);
            }
            throw e;
        }
        catch (UndeclaredThrowableException | ReflectionException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ClassNotFoundException) {
                if (jarFile != null) {
                    Logger.lineBreak();
                    Logger.increaseIndent();
                    Logger.println("MBean class is not known by the server.");
                    if (BeanshooterOption.DEPLOY_STAGER_URL.isNull()) {
                        Logger.eprintlnMixedYellow("Use the", BeanshooterOption.DEPLOY_STAGER_URL.getName(), "option to load the MBean from remote.");
                        Utils.exit(e);
                    }
                    DynamicMBean mbean = new DynamicMBean(mBeanObjectName, mBeanClassName, jarFile);
                    Dispatcher mLetDispatcher = new Dispatcher();
                    mLetDispatcher.loadMBeanFromURL(mbean, (String)BeanshooterOption.DEPLOY_STAGER_URL.getValue());
                    Logger.decreaseIndent();
                } else {
                    Logger.lineBreak();
                    Logger.eprintlnMixedBlue("The specified class", className, "is not known by the server.");
                    Logger.eprintMixedYellow("Use the", "--jar-file");
                    Logger.eprintlnPlainMixedYellow(" and", "--stager-url", "options to provide an implementation.");
                    Utils.exit(e);
                }
            } else {
                ExceptionHandler.unexpectedException(e, "deploying", "MBean", true);
            }
        }
        catch (SecurityException e) {
            Logger.lineBreak();
            if (e.getMessage().contains("Invalid access level")) {
                ExceptionHandler.insufficientPermission(e, "registering MBean", true);
            } else if (e.getMessage().contains("Creating an MBean that is a ClassLoader is forbidden")) {
                ExceptionHandler.protectedEndpoint(e, "registering MBean", true);
            } else {
                ExceptionHandler.unexpectedException(e, "registering", "MBean", true);
            }
        }
        catch (UnmarshalException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ClassNotFoundException) {
                String missingClass = t.getMessage().split(" ")[0];
                Logger.eprintlnMixedYellow("Caught", "ClassNotFoundException", "during MBean deployment.");
                Logger.eprintlnMixedBlue("The class", missingClass, "is not known by the server.");
                Utils.exit(e);
            }
            ExceptionHandler.unexpectedException(e, "registering", "MBean", true);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "registering", "MBean", true);
        }
        Logger.printMixedBlue("MBean with object name", mBeanObjectName.toString(), "was ");
        Logger.printlnPlainMixedYellowFirst("successfully", "deployed.");
    }

    public void unregisterMBean(ObjectName objectName) {
        Logger.printlnMixedYellow("Removing MBean with ObjectName", objectName.toString(), "from the MBeanServer.");
        try {
            this.conn.unregisterMBean(objectName);
        }
        catch (UnsupportedOperationException e) {
            if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
                ExceptionHandler.jolokiaRemoveMBean(e);
            }
            throw e;
        }
        catch (InstanceNotFoundException e) {
            Logger.println("MBean is not registered. Nothing to do.");
            return;
        }
        catch (SecurityException e) {
            Logger.lineBreak();
            if (e.getMessage().contains("Invalid access level")) {
                ExceptionHandler.insufficientPermission(e, "unregistering MBean", true);
            } else {
                ExceptionHandler.unexpectedException(e, "unregistering", "MBean", true);
            }
        }
        catch (IOException | MBeanRegistrationException e) {
            ExceptionHandler.unexpectedException(e, "unregistering", "MBean", true);
        }
        Logger.println("MBean was successfully removed.");
    }

    public Set<ObjectInstance> getMBeans() {
        try {
            return this.conn.queryMBeans(null, null);
        }
        catch (IOException e) {
            ExceptionHandler.unexpectedException(e, "listing", "MBeans", true);
            return null;
        }
    }

    public Object invoke(ObjectName name, String methodName, String[] argTypes, Object ... args) throws IOException, MBeanException, ReflectionException {
        Object result = null;
        if (argTypes == null && args != null) {
            argTypes = new String[args.length];
            for (int ctr = 0; ctr < args.length; ++ctr) {
                argTypes[ctr] = args[ctr].getClass().getName();
            }
        }
        try {
            result = this.conn.invoke(name, methodName, args, argTypes);
        }
        catch (InstanceNotFoundException e) {
            ExceptionHandler.handleInstanceNotFound(e, name.toString());
        }
        catch (ReflectionException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof NoSuchMethodException) {
                ExceptionHandler.noSuchMethod(e, methodName);
            }
            throw e;
        }
        catch (SecurityException e) {
            String message = e.getMessage();
            if (message.contains("Access denied!")) {
                ExceptionHandler.mBeanAccessDenied(e, name.toString(), methodName);
            }
            throw e;
        }
        catch (MBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            String message = t.getMessage();
            if (t instanceof J4pRemoteException && message.contains("javax.management.InstanceNotFoundException")) {
                ExceptionHandler.handleInstanceNotFound(e, name.toString());
            }
            throw e;
        }
        catch (RuntimeOperationsException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException) {
                CharSequence[] actualArgumentTypes = new String[args.length];
                for (int ctr = 0; ctr < args.length; ++ctr) {
                    actualArgumentTypes[ctr] = args[ctr].getClass().getName();
                }
                Logger.eprintlnMixedYellow("Caught unexpected", "IllegalArgumentException", "while invoking the method.");
                Logger.eprintlnMixedBlue("The specified argument types:", String.join((CharSequence)", ", actualArgumentTypes));
                Logger.eprintlnMixedBlue("Do not match the expected argument types:", String.join((CharSequence)" ,", argTypes));
                Utils.exit(e);
            }
            throw e;
        }
        return result;
    }

    public Object getAttribute(ObjectName name, String attributeName) throws MBeanException, ReflectionException, IOException {
        try {
            return this.conn.getAttribute(name, attributeName);
        }
        catch (UncheckedJmxAdapterException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof J4pRemoteException) {
                String message = t.getMessage();
                if (message.contains("InstanceNotFoundException")) {
                    ExceptionHandler.handleInstanceNotFound(e, name.toString());
                } else if (message.contains("AttributeNotFoundException")) {
                    ExceptionHandler.noSuchAttribute(e, attributeName);
                }
            }
            throw e;
        }
        catch (InstanceNotFoundException e) {
            ExceptionHandler.handleInstanceNotFound(e, name.toString());
        }
        catch (AttributeNotFoundException e) {
            ExceptionHandler.noSuchAttribute(e, attributeName);
        }
        return null;
    }

    public void setAttribute(ObjectName name, Attribute attr) throws MBeanException, ReflectionException, IOException {
        try {
            this.conn.setAttribute(name, attr);
        }
        catch (UncheckedJmxAdapterException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof J4pRemoteException) {
                String message = t.getMessage();
                if (message.contains("InstanceNotFoundException")) {
                    ExceptionHandler.handleInstanceNotFound(e, name.toString());
                } else if (message.contains("AttributeNotFoundException")) {
                    ExceptionHandler.noSuchAttribute(e, attr.getName());
                } else if (message.contains("InvalidAttributeValueException")) {
                    Logger.eprintlnMixedYellow("Caught", "InvalidAttributeValueException", "while setting the attribute.");
                    Logger.eprintlnMixedBlue("The specified attribute value of class", attr.getValue().getClass().getName(), "is probably not compatible.");
                    Logger.eprintlnMixedYellow("You can use the", "--type", "option to specify a different type manually.");
                    Utils.exit(e);
                }
            }
            throw e;
        }
        catch (InstanceNotFoundException e) {
            ExceptionHandler.handleInstanceNotFound(e, name.toString());
        }
        catch (AttributeNotFoundException e) {
            ExceptionHandler.noSuchAttribute(e, attr.getName());
        }
        catch (InvalidAttributeValueException e) {
            Logger.eprintlnMixedYellow("Caught", "InvalidAttributeValueException", "while setting the attribute.");
            Logger.eprintlnMixedBlue("The specified attribute value of class", attr.getValue().getClass().getName(), "is probably not compatible.");
            Logger.eprintlnMixedYellow("You can use the", "--type", "option to specify a different type manually.");
            Utils.exit(e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this.conn.getMBeanInfo(name);
        }
        catch (InstanceNotFoundException e) {
            ExceptionHandler.handleInstanceNotFound(e, name.toString());
        }
        catch (IOException | IntrospectionException | ReflectionException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "MBeanInfo", true);
        }
        return null;
    }

    public MBeanServerConnection getConnection() {
        return this.conn;
    }
}

