/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.operation;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.SaslProfileException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.io.ProgressBar;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.operation.EnumHelper;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jolokia.client.exception.J4pRemoteException;

public class CredentialGuesser {
    private final String host;
    private final int port;
    private final int count;
    private final GuessingProgressBar bar;
    private final Map<String, Set<String>> credentials;
    private ExecutorService pool;

    public CredentialGuesser(String host, int port, Map<String, Set<String>> credentials) {
        this.host = host;
        this.port = port;
        this.credentials = credentials;
        this.count = this.countItems();
        this.bar = new GuessingProgressBar(this.count, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGuessing() {
        Logger.printlnMixedYellow("Starting bruteforce attack with", String.valueOf(this.count), "credentials.");
        Logger.lineBreak();
        Logger.increaseIndent();
        EnumHelper enumHelper = new EnumHelper(this.host, this.port);
        if (BeanshooterOption.CONN_SASL.isNull() && !enumHelper.requiresLogin()) {
            Logger.printlnMixedYellow("The targeted JMX service accepts", "unauthenticated", "connections.");
            Logger.println("No need to bruteforce credentials.");
            return;
        }
        enumHelper.checkLoginFormat();
        int threads = (Integer)ArgumentHandler.require(BeanshooterOption.BRUTE_THREADS);
        this.pool = Executors.newFixedThreadPool(threads);
        for (Map.Entry<String, Set<String>> entry : this.credentials.entrySet()) {
            for (Set<String> pwSet : Utils.splitSet(entry.getValue(), threads)) {
                GuessingWorker r = new GuessingWorker(entry.getKey(), pwSet);
                this.pool.execute(r);
            }
        }
        try {
            this.pool.shutdown();
            this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.eprintln("Interrupted!");
        }
        finally {
            Logger.decreaseIndent();
            this.bar.done();
            Logger.lineBreak();
            Logger.println("done.");
        }
    }

    private int countItems() {
        int count = 0;
        for (Map.Entry<String, Set<String>> entry : this.credentials.entrySet()) {
            count += entry.getValue().size();
        }
        return count;
    }

    private class GuessingProgressBar
    extends ProgressBar {
        public GuessingProgressBar(int work, int length) {
            super(work, length);
        }

        public synchronized void printSuccess(String username, String password) {
            Logger.print(new String(new char[this.length + 20]).replace("\u0000", " ") + "\r");
            Logger.printlnMixedYellow("Found valid credentials:", String.format("%s:%s", username, password));
        }
    }

    private class GuessingWorker
    implements Runnable {
        private final String username;
        private final Set<String> passwords;

        public GuessingWorker(String username, Set<String> passwords) {
            this.username = username;
            this.passwords = passwords;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (String password : this.passwords) {
                Map<String, Object> env = PluginSystem.getEnv(this.username, password);
                try {
                    PluginSystem.getMBeanServerConnectionUmanaged(CredentialGuesser.this.host, CredentialGuesser.this.port, env);
                    CredentialGuesser.this.bar.printSuccess(this.username, password);
                    if (!BeanshooterOption.BRUTE_FIRST.getBool()) continue;
                    CredentialGuesser.this.pool.shutdownNow();
                }
                catch (SaslProfileException e) {
                    CredentialGuesser.this.bar.printSuccess(this.username, password);
                    if (!BeanshooterOption.BRUTE_FIRST.getBool()) continue;
                    CredentialGuesser.this.pool.shutdownNow();
                }
                catch (J4pRemoteException e) {
                    ExceptionHandler.handleJ4pRemoteException(e, "during login attempt");
                }
                catch (AuthenticationException authenticationException) {}
                continue;
                finally {
                    CredentialGuesser.this.bar.taskDone();
                }
            }
        }
    }
}

