/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.tonkabean;

import de.qtc.beanshooter.cli.ArgType;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.cli.OptionGroup;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;

public enum TonkaBeanOption implements Option
{
    SHELL_CMD("--shell", "the shell command to use for execution", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "shell"),
    EXEC_BACK("--background", "execute the command in the background", Arguments.storeTrue(), OptionGroup.ACTION, ArgType.BOOL),
    EXEC_CMD("cmd", "command to execute", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    EXEC_ARRAY("cmd", "command to execute", Arguments.store(), OptionGroup.ACTION, ArgType.ARRAY),
    EXEC_CWD("--cwd", "working directory to execute the command in", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "cwd"),
    EXEC_ENV("--env", "environment variables to use with the command", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "env"),
    EXEC_HEX("--hex", "return the command output as hexstring", Arguments.storeTrue(), OptionGroup.ACTION, ArgType.BOOL),
    EXEC_FILE("--output-file", "write the command output into a file", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "file"),
    EXEC_RAW("--raw", "return the raw output of the command without diagnostic messages", Arguments.storeTrue(), OptionGroup.ACTION, ArgType.BOOL),
    UPLOAD_SOURCE("local", "local file to upload onto the server", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    UPLOAD_DEST("remote", "remote path to upload the file to", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    DOWNLOAD_SOURCE("remote", "remote path to download the file from", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    DOWNLOAD_DEST("local", "local path to save the downloaded file to", Arguments.store(), OptionGroup.ACTION, ArgType.STRING);

    private final String name;
    private final String description;
    private final String metavar;
    private final ArgType type;
    private final ArgumentAction argumentAction;
    private OptionGroup optionGroup = null;
    private Object value = null;

    private TonkaBeanOption(String name, String description, ArgumentAction argumentAction, OptionGroup optionGroup, ArgType type) {
        this(name, description, argumentAction, optionGroup, type, null);
    }

    private TonkaBeanOption(String name, String description, ArgumentAction argumentAction, OptionGroup optionGroup, ArgType type, String metavar) {
        this.name = name;
        this.description = description;
        this.argumentAction = argumentAction;
        this.type = type;
        this.metavar = metavar;
        this.optionGroup = optionGroup;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean notNull() {
        return this.value != null;
    }

    @Override
    public boolean getBool() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    @Override
    public <T> T getValue() {
        try {
            return (T)this.value;
        }
        catch (ClassCastException e) {
            ExceptionHandler.internalError("Beanshooter.getValue", "ClassCastException was caught.");
            return null;
        }
    }

    public <T> T getValue(T def) {
        if (this.value == null) {
            return def;
        }
        try {
            return (T)this.value;
        }
        catch (ClassCastException e) {
            ExceptionHandler.internalError("Beanshooter.getValue", "ClassCastException was caught.");
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setValue(Object value, Object def) {
        this.value = value != null ? value : def;
    }

    @Override
    public void setValue(Namespace args, Object def) {
        this.value = args.get(this.name.replaceFirst("--", "").replace("-", "_"));
        this.setValue(this.value, def);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ArgType getArgType() {
        return this.type;
    }

    @Override
    public OptionGroup optionGroup() {
        return this.optionGroup;
    }

    @Override
    public ArgumentAction argumentAction() {
        return this.argumentAction;
    }

    @Override
    public String metavar() {
        return this.metavar;
    }
}

