/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.tonkabean;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanMBean;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanOption;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private String cwd = ".";
    private Map<String, String> env = new HashMap<String, String>();
    private TonkaBeanMBean tonkaBean;

    public Dispatcher() {
        super(MBean.TONKA);
        if (BeanshooterOption.TARGET_HOST.isNull()) {
            return;
        }
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.tonkaBean = (TonkaBeanMBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{TonkaBeanMBean.class}, (InvocationHandler)invo);
    }

    public void version() {
        try {
            Logger.printlnBlue(this.tonkaBean.version());
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "version", true);
        }
    }

    public void execute() {
        List<Object> cmdList = new ArrayList<String>();
        String command = (String)ArgumentHandler.require(TonkaBeanOption.EXEC_CMD);
        if (TonkaBeanOption.SHELL_CMD.notNull()) {
            cmdList = this.getShell(null);
            cmdList.add(command);
        } else {
            cmdList.addAll(Arrays.asList(Utils.splitSpaces(command, 1)));
        }
        this.executeCommand(cmdList);
    }

    public void executeArray() {
        List cmdList = (List)ArgumentHandler.require(TonkaBeanOption.EXEC_ARRAY);
        this.executeCommand(cmdList);
    }

    public void executeCommand(List<String> command) {
        block12: {
            String cwd = TonkaBeanOption.EXEC_CWD.getValue(".");
            boolean background = TonkaBeanOption.EXEC_BACK.getBool();
            Map<String, String> env = Utils.parseEnvironmentString(TonkaBeanOption.EXEC_ENV.getValue(""));
            String[] envArray = this.envToString(env);
            if (TonkaBeanOption.EXEC_RAW.getBool()) {
                Logger.disableStdout();
            }
            Logger.printMixedYellow("Invoking the", "executeCommand", "method with arguments: ");
            Logger.printlnPlainBlue(Arrays.toString(command.toArray(new String[0])));
            try {
                byte[] result = this.tonkaBean.executeCommand(command.toArray(new String[0]), cwd, envArray, background);
                if (background) {
                    return;
                }
                Logger.printlnBlue("The call was successful");
                Logger.lineBreak();
                if (TonkaBeanOption.EXEC_HEX.getBool()) {
                    Logger.printlnYellow("Server response:");
                    System.out.println(Utils.bytesToHex(result));
                    break block12;
                }
                if (TonkaBeanOption.EXEC_FILE.notNull()) {
                    try (FileOutputStream stream = new FileOutputStream((String)TonkaBeanOption.EXEC_FILE.getValue());){
                        stream.write(result);
                    }
                    Logger.printlnMixedYellow("Command output saved in", (String)TonkaBeanOption.EXEC_FILE.getValue());
                    break block12;
                }
                Logger.printlnYellow("Server response:");
                System.out.write(result);
            }
            catch (MBeanException e) {
                ExceptionHandler.handleMBeanGeneric(e);
                ExceptionHandler.handleExecException(e, command);
            }
            catch (IOException e) {
                ExceptionHandler.handleFileWrite(e, (String)TonkaBeanOption.EXEC_FILE.getValue(), true);
            }
        }
    }

    public void upload() {
        String uploadDest = TonkaBeanOption.UPLOAD_DEST.getValue(null);
        File uploadFile = new File((String)ArgumentHandler.require(TonkaBeanOption.UPLOAD_SOURCE));
        String uploadSrc = uploadFile.toPath().normalize().toAbsolutePath().toString();
        if (uploadDest == null) {
            uploadDest = ".";
        }
        Logger.printMixedYellow("Uploading local file", uploadSrc, "to path ");
        Logger.printlnPlainMixedBlueFirst(uploadDest, "on the MBeanSerer.");
        try {
            byte[] content = Utils.readFile(uploadFile);
            String finalPath = this.tonkaBean.uploadFile(uploadDest, uploadFile.getName(), content);
            Logger.printlnMixedYellowFirst(content.length + " bytes", "were written to", finalPath);
        }
        catch (MBeanException e) {
            ExceptionHandler.handleMBeanGeneric(e);
            ExceptionHandler.handleFileWrite(e, uploadDest, true);
        }
        catch (IOException e) {
            ExceptionHandler.handleFileRead(e, uploadSrc, true);
        }
    }

    public void download() {
        File localFile;
        String downloadDest = TonkaBeanOption.DOWNLOAD_DEST.getValue(null);
        File downloadSrc = new File((String)ArgumentHandler.require(TonkaBeanOption.DOWNLOAD_SOURCE));
        if (downloadDest == null) {
            downloadDest = downloadSrc.getName();
        }
        if ((localFile = new File(downloadDest)).isDirectory()) {
            localFile = Paths.get(downloadDest, downloadSrc.getName()).normalize().toFile();
        }
        Logger.printMixedYellow("Saving remote file", downloadSrc.getPath(), "to local path ");
        Logger.printlnPlainBlue(localFile.getAbsolutePath());
        try {
            byte[] content = this.tonkaBean.downloadFile(downloadSrc.getPath());
            FileOutputStream stream = new FileOutputStream(localFile);
            stream.write(content);
            stream.close();
            Logger.printlnMixedYellowFirst(content.length + " bytes", "were written to", localFile.getAbsolutePath());
        }
        catch (MBeanException e) {
            ExceptionHandler.handleMBeanGeneric(e);
            ExceptionHandler.handleFileRead(e, downloadSrc.getPath(), true);
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, localFile.getAbsolutePath(), true);
        }
    }

    public void shell() {
        String command;
        Console console = System.console();
        this.initCwd();
        String targetHost = (String)BeanshooterOption.TARGET_HOST.getValue();
        String[] shellVars = this.shellInit();
        String username = shellVars[0];
        String hostname = shellVars[1];
        String separator = shellVars[2];
        List<String> shell = this.getShell(separator);
        if (hostname == null) {
            hostname = targetHost;
        }
        do {
            Logger.printPlainYellow(String.format("[%s@%s", username, hostname));
            Logger.printPlainMixedBlue("", this.cwd);
            Logger.printPlainYellow("]");
            Logger.printPlain("$ ");
        } while (this.handleShellCommand(command = console.readLine(), shell));
    }

    private boolean handleShellCommand(String command, List<String> shellCmd) {
        if (command == null) {
            return false;
        }
        String[] commandArray = command.trim().split(" ", 2);
        ArrayList<String> shell = new ArrayList<String>(shellCmd);
        switch (commandArray[0]) {
            case "exit": 
            case "quit": {
                return false;
            }
            case "cd": {
                if (commandArray.length <= 1) break;
                this.shellChangeDirectory(commandArray[1]);
                break;
            }
            case "!background": 
            case "!back": {
                if (commandArray.length <= 1) break;
                this.shellCommand(commandArray[1], shell, this.env, true);
                break;
            }
            case "!download": 
            case "!get": {
                if (commandArray.length <= 1) break;
                this.shellDownload(commandArray[1]);
                break;
            }
            case "!upload": 
            case "!put": {
                if (commandArray.length <= 1) break;
                this.shellUpload(commandArray[1]);
                break;
            }
            case "!environ": 
            case "!env": {
                this.env.putAll(Utils.parseEnvironmentString(command));
                break;
            }
            case "!help": 
            case "!h": {
                this.shellHelp();
                break;
            }
            default: {
                this.shellCommand(command, shell, this.env, false);
            }
        }
        return true;
    }

    private void shellChangeDirectory(String change) {
        try {
            this.cwd = this.tonkaBean.toServerDir(this.cwd, change);
        }
        catch (MBeanException | RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IOException || t instanceof InvalidPathException) {
                System.out.println(e.getMessage());
            }
            Logger.printlnMixedYellow("Caught unexpected", t.getClass().getName(), "while changing directory.");
            ExceptionHandler.stackTrace(e);
        }
    }

    private void shellCommand(String command, List<String> shell, Map<String, String> env, boolean background) {
        shell.add(command);
        String[] envArray = this.envToString(env);
        String[] commandArray = shell.toArray(new String[0]);
        try {
            byte[] result = this.tonkaBean.executeCommand(commandArray, this.cwd, envArray, background);
            if (background) {
                Logger.printlnBlue("Command is executed in the background.");
                return;
            }
            System.out.write(result);
        }
        catch (MBeanException e) {
            ExceptionHandler.handleShellExecException(e, commandArray);
        }
        catch (IOException e) {
            ExceptionHandler.unexpectedException(e, "writing", "command output", false);
        }
    }

    private void shellUpload(String argument) {
        String[] arguments = Utils.splitSpaces(argument, 1);
        File source = new File(Utils.expandPath(arguments[0]));
        File destination = new File(".");
        if (arguments.length > 1) {
            destination = new File(arguments[1]);
        }
        if (!destination.isAbsolute()) {
            destination = Paths.get(this.cwd, destination.getPath()).toAbsolutePath().normalize().toFile();
        }
        if (!source.isAbsolute()) {
            source = Paths.get(".", source.getPath()).toAbsolutePath().normalize().toFile();
        }
        try {
            byte[] content = Utils.readFile(source);
            String finalPath = this.tonkaBean.uploadFile(destination.getPath(), source.getName(), content);
            Logger.printlnPlainMixedBlueFirst(content.length + " bytes", "were written to", finalPath);
        }
        catch (MBeanException e) {
            ExceptionHandler.handleMBeanGeneric(e);
            ExceptionHandler.handleFileWrite(e, destination.getPath(), false);
        }
        catch (IOException e) {
            ExceptionHandler.handleFileRead(e, source.getPath(), false);
        }
    }

    private void shellDownload(String argument) {
        String[] arguments = Utils.splitSpaces(argument, 1);
        File source = new File(arguments[0]);
        File destination = new File(source.getName());
        if (arguments.length > 1) {
            destination = new File(Utils.expandPath(arguments[1]));
        }
        if (!source.isAbsolute()) {
            source = Paths.get(this.cwd, source.getPath()).toAbsolutePath().normalize().toFile();
        }
        if (!destination.isAbsolute()) {
            destination = Paths.get(".", destination.getPath()).toAbsolutePath().normalize().toFile();
        }
        if (destination.isDirectory()) {
            destination = Paths.get(destination.toPath().toString(), source.getName()).toFile();
        }
        try {
            byte[] content = this.tonkaBean.downloadFile(source.getPath());
            FileOutputStream stream = new FileOutputStream(destination);
            stream.write(content);
            stream.close();
            Logger.printlnPlainMixedBlueFirst(content.length + " bytes", "were written to", destination.getPath());
        }
        catch (MBeanException e) {
            ExceptionHandler.handleMBeanGeneric(e);
            ExceptionHandler.handleFileRead(e, source.getPath(), false);
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, destination.getPath(), false);
        }
    }

    private String[] shellInit() {
        try {
            return this.tonkaBean.shellInit();
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "initializing", "shell", true);
            return null;
        }
    }

    private void initCwd() {
        try {
            this.cwd = this.tonkaBean.toServerDir(this.cwd, ".");
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
    }

    private void shellHelp() {
        Logger.printlnPlainYellow("Available shell commands:");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  <cmd>", 30), "execute the specified command");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  cd <dir>", 30), "change working directory on the server");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  exit|quit", 30), "exit the shell");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  !help|!h", 30), "print this help menu");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  !environ|!env <key>=<value>", 30), "set new environment variables in key=value format");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  !upload|!put <src> <dst>", 30), "upload a file to the remote MBeanServer");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  !download|!get <src> <dst>", 30), "download a file from the remote MBeanServer");
        Logger.printlnPlainMixedBlueFirst(Logger.padRight("  !background|!back <cmd>", 30), "executes the specified command in the background");
    }

    private List<String> getShell(String separator) {
        ArrayList<String> shell = new ArrayList<String>();
        String shellCmd = TonkaBeanOption.SHELL_CMD.getValue(null);
        if (shellCmd != null) {
            shell.addAll(Arrays.asList(shellCmd.trim().split(" ")));
            this.addShellArgument(shell);
            return shell;
        }
        if (separator != null) {
            if (separator.equals("/")) {
                shell.add("sh");
                shell.add("-c");
            } else if (separator.equals("\\")) {
                shell.add("cmd.exe");
                shell.add("/C");
            } else {
                ExceptionHandler.internalError("Dispatcher.getShell", "Unhandeled path separator: " + separator);
            }
        } else {
            ExceptionHandler.internalError("Dispatcher.getShell", "Called without a separator");
        }
        return shell;
    }

    private void addShellArgument(List<String> command) {
        if (command.size() > 1) {
            return;
        }
        String shellCommand = command.get(0);
        for (char sep : new char[]{'/', '\\'}) {
            int index = shellCommand.lastIndexOf(sep);
            if (index <= 0) continue;
            shellCommand = shellCommand.substring(index + 1);
        }
        switch (shellCommand) {
            case "sh": 
            case "ash": 
            case "bash": 
            case "powershell": 
            case "powershell.exe": {
                command.add("-c");
                break;
            }
            case "cmd": 
            case "cmd.exe": {
                command.add("/C");
            }
        }
    }

    private String[] envToString(Map<String, String> env) {
        int ctr = 0;
        String[] envArray = new String[env.keySet().size() * 2];
        for (Map.Entry<String, String> entry : env.entrySet()) {
            envArray[ctr++] = entry.getKey();
            envArray[ctr++] = entry.getValue();
        }
        return envArray;
    }
}

