/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.tomcat;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.mbean.Dispatcher;
import de.qtc.beanshooter.mbean.DynamicMBean;
import de.qtc.beanshooter.mbean.IMBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.tomcat.UserMBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.MBeanException;

public class UserBeanDispatcher
extends Dispatcher {
    private final UserMBean userBean;

    public UserBeanDispatcher(IMBean bean) {
        super(bean);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(bean.getObjectName(), this.getMBeanServerConnection());
        this.userBean = (UserMBean)Proxy.newProxyInstance(de.qtc.beanshooter.mbean.tomcat.Dispatcher.class.getClassLoader(), new Class[]{UserMBean.class}, (InvocationHandler)invo);
    }

    public String getName() {
        try {
            return (String)this.userBean.getAttribute("username");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "tomcat username", false);
            return "unknown error";
        }
    }

    public String[] getRoles() {
        try {
            return (String[])this.userBean.getAttribute("roles");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "tomcat user roles", false);
            return new String[0];
        }
    }

    public String[] getGroups() {
        try {
            return (String[])this.userBean.getAttribute("groups");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "tomcat user roles", false);
            return new String[0];
        }
    }

    public String getPassword() {
        try {
            return (String)this.userBean.getAttribute("password");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "tomcat user roles", false);
            return null;
        }
    }

    public static UserBeanDispatcher getDispatcher(String userObjectName) {
        DynamicMBean dynBean = new DynamicMBean(userObjectName, "org.apache.catalina.mbeans", null);
        return new UserBeanDispatcher(dynBean);
    }
}

