/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.mlet;

import de.qtc.beanshooter.cli.ArgType;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.cli.OptionGroup;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;

public enum MLetOption implements Option
{
    LOAD_BEAN("bean", "name of the bean to load ('custom' for custom MBean)", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    LOAD_URL("url", "URL to load the MBean from", Arguments.store(), OptionGroup.ACTION, ArgType.STRING),
    LOAD_CLASS_NAME("--class-name", "class name of the MBean to load", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "class"),
    LOAD_JAR_FILE("--jar-file", "path to the jar file that implements the MBean", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "path"),
    LOAD_OBJECT_NAME("--object-name", "object name of the custom MBean", Arguments.store(), OptionGroup.ACTION, ArgType.STRING, "objname");

    private final String name;
    private final String description;
    private final String metavar;
    private final ArgType type;
    private final ArgumentAction argumentAction;
    private OptionGroup optionGroup = null;
    private Object value = null;

    private MLetOption(String name, String description, ArgumentAction argumentAction, OptionGroup optionGroup, ArgType type) {
        this(name, description, argumentAction, optionGroup, type, null);
    }

    private MLetOption(String name, String description, ArgumentAction argumentAction, OptionGroup optionGroup, ArgType type, String metavar) {
        this.name = name;
        this.description = description;
        this.argumentAction = argumentAction;
        this.type = type;
        this.metavar = metavar;
        this.optionGroup = optionGroup;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean notNull() {
        return this.value != null;
    }

    @Override
    public boolean getBool() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    @Override
    public <T> T getValue() {
        try {
            return (T)this.value;
        }
        catch (ClassCastException e) {
            ExceptionHandler.internalError("RMGOption.getValue", "ClassCastException was caught.");
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setValue(Object value, Object def) {
        this.value = value != null ? value : def;
    }

    @Override
    public void setValue(Namespace args, Object def) {
        this.value = args.get(this.name.replaceFirst("--", "").replace("-", "_"));
        this.setValue(this.value, def);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ArgType getArgType() {
        return this.type;
    }

    @Override
    public OptionGroup optionGroup() {
        return this.optionGroup;
    }

    @Override
    public ArgumentAction argumentAction() {
        return this.argumentAction;
    }

    @Override
    public String metavar() {
        return this.metavar;
    }
}

